/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.config;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.UIManager;
import org.springframework.richclient.application.ApplicationException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class UIManagerConfigurer {
    private static final String CROSS_PLATFORM_LOOK_AND_FEEL_NAME = "crossPlatform";
    private static final String SYSTEM_LOOK_AND_FEEL_NAME = "system";

    public UIManagerConfigurer() {
        this(true);
    }

    public UIManagerConfigurer(boolean installPrePackagedDefaults) {
        if (installPrePackagedDefaults) {
            this.installPrePackagedUIManagerDefaults();
        }
        try {
            this.doInstallCustomDefaults();
        }
        catch (Exception e) {
            throw new ApplicationException("Unable to install subclass custom defaults", (Throwable)e);
        }
    }

    protected void doInstallCustomDefaults() throws Exception {
    }

    private void installPrePackagedUIManagerDefaults() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            UIManager.put("Tree.line", "Angled");
            UIManager.put("Tree.leafIcon", null);
            UIManager.put("Tree.closedIcon", null);
            UIManager.put("Tree.openIcon", null);
            UIManager.put("Tree.rightChildIndent", new Integer(10));
        }
        catch (Exception e) {
            throw new ApplicationException("Unable to set defaults", (Throwable)e);
        }
    }

    public void setProperties(Properties properties) {
        Iterator<Map.Entry<Object, Object>> i = properties.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> entry = i.next();
            UIManager.put(entry.getKey(), entry.getValue());
        }
    }

    public void setInstallCustomLookAndFeels(String[] customLookAndFeels) {
        for (int i = 0; i < customLookAndFeels.length; ++i) {
            String className;
            String[] feels = StringUtils.commaDelimitedListToStringArray((String)customLookAndFeels[i]);
            Assert.isTrue((feels.length > 0 ? 1 : 0) != 0, (String)"LookAndFeelInfo definition should be in form: [name],<classname>");
            String name = null;
            if (feels.length == 1) {
                className = feels[0];
            } else if (feels.length > 1) {
                name = feels[0];
                className = feels[1];
            } else {
                throw new RuntimeException("Should not happen");
            }
            UIManager.installLookAndFeel(name, className);
        }
    }

    public void setLookAndFeel(Class lookAndFeel) {
        this.setLookAndFeel(lookAndFeel.getName());
    }

    public void setLookAndFeel(String className) {
        try {
            UIManager.setLookAndFeel(className);
        }
        catch (Exception e) {
            throw new ApplicationException("Unable to set look and feel", (Throwable)e);
        }
    }

    public void setLookAndFeelWithName(String lookAndFeelName) {
        block5: {
            try {
                if (lookAndFeelName.equalsIgnoreCase(SYSTEM_LOOK_AND_FEEL_NAME)) {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    break block5;
                }
                if (lookAndFeelName.equalsIgnoreCase(CROSS_PLATFORM_LOOK_AND_FEEL_NAME)) {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                    break block5;
                }
                UIManager.LookAndFeelInfo[] feels = UIManager.getInstalledLookAndFeels();
                for (int i = 0; i < feels.length; ++i) {
                    UIManager.LookAndFeelInfo feel = feels[i];
                    if (!feel.getName().equalsIgnoreCase(lookAndFeelName)) continue;
                    UIManager.setLookAndFeel(feel.getClassName());
                    break;
                }
            }
            catch (Exception e) {
                throw new ApplicationException("Unable to set look and feel", (Throwable)e);
            }
        }
    }
}

