/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.setup;

import java.awt.Dimension;
import javax.swing.JOptionPane;
import org.springframework.core.io.Resource;
import org.springframework.richclient.application.setup.SetupIntroWizardPage;
import org.springframework.richclient.application.setup.SetupLicenseWizardPage;
import org.springframework.richclient.application.setup.SetupWizardDialog;
import org.springframework.richclient.command.ActionCommandExecutor;
import org.springframework.richclient.wizard.AbstractWizard;
import org.springframework.richclient.wizard.WizardDialog;

public class SetupWizard
extends AbstractWizard
implements ActionCommandExecutor {
    private WizardDialog wizardDialog;
    private SetupLicenseWizardPage licensePage = new SetupLicenseWizardPage();

    public SetupWizard() {
        super("setup");
    }

    public void setLicenseTextLocation(Resource location) {
        this.licensePage.setLicenseTextLocation(location);
    }

    public void execute() {
        if (this.wizardDialog == null) {
            this.wizardDialog = new SetupWizardDialog(this);
            this.wizardDialog.setPreferredSize(new Dimension(500, 300));
        }
        this.wizardDialog.showDialog();
    }

    public void addPages() {
        this.addPage(new SetupIntroWizardPage());
        this.addPage(this.licensePage);
    }

    public boolean onFinish() {
        return true;
    }

    public boolean onCancel() {
        if (this.cancelConfirmed()) {
            System.exit(1);
        }
        return false;
    }

    protected boolean cancelConfirmed() {
        return JOptionPane.showConfirmDialog(this.wizardDialog.getDialog(), this.getCancelMessage(), this.getCancelTitle(), 0, 3) != 1;
    }

    protected String getCancelTitle() {
        return this.getMessage("setup.cancel.title");
    }

    protected String getCancelMessage() {
        return this.getMessage("setup.cancel.message");
    }
}

