/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.statusbar.support;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.richclient.application.statusbar.StatusBar;
import org.springframework.richclient.application.statusbar.support.StatusBarProgressMonitor;
import org.springframework.richclient.control.ShadowBorder;
import org.springframework.richclient.core.Message;
import org.springframework.richclient.factory.AbstractControlFactory;
import org.springframework.richclient.progress.ProgressMonitor;

public class DefaultStatusBar
extends AbstractControlFactory
implements StatusBar {
    private static Log logger = LogFactory.getLog((Class)DefaultStatusBar.class);
    private String message;
    private String errorMessage;
    private JLabel messageLabel;
    private JPanel statusBar;
    private StatusBarProgressMonitor progressMonitor;

    public ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public void setCancelEnabled(boolean enabled) {
        this.progressMonitor.setCancelEnabled(enabled);
    }

    public void setMessage(Message message) {
        this.setMessage(message == null ? null : message.getMessage());
    }

    public void setMessage(String message) {
        this.message = message;
        if (this.errorMessage == null) {
            logger.debug((Object)("Setting status bar message to \"" + message + "\""));
            this.messageLabel.setText(this.message);
        }
    }

    public void setErrorMessage(Message errorMessage) {
        this.setErrorMessage(errorMessage == null ? null : errorMessage.getMessage());
    }

    public void setErrorMessage(String errorMessage) {
        if (errorMessage == null) {
            logger.debug((Object)"Resetting the status bar message color to normal");
            this.messageLabel.setForeground(SystemColor.controlText);
            this.errorMessage = null;
            this.setMessage(this.message);
        } else {
            logger.debug((Object)"Setting the status bar messsage color to red");
            this.messageLabel.setForeground(Color.RED);
            logger.debug((Object)("Setting status bar error message to \"" + errorMessage + "\""));
            this.errorMessage = errorMessage;
            this.messageLabel.setText(this.errorMessage);
        }
    }

    protected JLabel createMessageLabel() {
        JLabel messageLabel = new JLabel(" ");
        messageLabel.setName("message");
        Border bevelBorder = BorderFactory.createBevelBorder(1, UIManager.getColor("controlHighlight"), UIManager.getColor("controlShadow"));
        Border emptyBorder = BorderFactory.createEmptyBorder(1, 3, 1, 3);
        messageLabel.setBorder(BorderFactory.createCompoundBorder(bevelBorder, emptyBorder));
        return messageLabel;
    }

    protected JComponent createControl() {
        this.statusBar = new JPanel(new BorderLayout());
        this.messageLabel = this.createMessageLabel();
        this.progressMonitor = this.createStatusBarProgressMonitor();
        this.statusBar.add(this.messageLabel);
        this.statusBar.add((Component)this.progressMonitor.getControl(), "East");
        this.progressMonitor.getControl().setPreferredSize(new Dimension(200, 17));
        this.statusBar.setBorder(new ShadowBorder());
        return this.statusBar;
    }

    protected StatusBarProgressMonitor createStatusBarProgressMonitor() {
        return new StatusBarProgressMonitor();
    }

    public void setVisible(boolean visible) {
        this.statusBar.setVisible(visible);
    }

    public void clear() {
        this.setErrorMessage((String)null);
        this.setMessage((String)null);
    }
}

