/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.support;

import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.richclient.application.ApplicationWindow;
import org.springframework.richclient.application.PageComponent;
import org.springframework.richclient.application.View;
import org.springframework.richclient.application.ViewDescriptor;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.command.config.CommandButtonLabelInfo;
import org.springframework.richclient.command.support.ShowViewCommand;
import org.springframework.richclient.core.LabeledObjectSupport;
import org.springframework.util.Assert;

public class DefaultViewDescriptor
extends LabeledObjectSupport
implements ViewDescriptor,
BeanNameAware {
    private String id;
    private Class viewClass;
    private Map viewProperties;

    public void setBeanName(String beanName) {
        this.setId(beanName);
    }

    public void setId(String id) {
        Assert.notNull((Object)"id is required");
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setViewClass(Class viewClass) {
        this.viewClass = viewClass;
    }

    public void setViewProperties(Map viewProperties) {
        this.viewProperties = viewProperties;
    }

    public PageComponent createPageComponent() {
        return this.createView();
    }

    protected View createView() {
        Assert.state((this.viewClass != null ? 1 : 0) != 0, (String)"View class to instantiate is not set");
        Object o = BeanUtils.instantiateClass((Class)this.viewClass);
        Assert.isTrue((boolean)(o instanceof View), (String)("View class '" + this.viewClass + "' was instantiated, but instance is not a View!"));
        View view = (View)o;
        view.setDescriptor(this);
        if (this.viewProperties != null) {
            BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)view);
            wrapper.setPropertyValues(this.viewProperties);
        }
        if (view instanceof InitializingBean) {
            try {
                ((InitializingBean)view).afterPropertiesSet();
            }
            catch (Exception e) {
                throw new BeanInitializationException("Problem running on " + view, (Throwable)e);
            }
        }
        return view;
    }

    public CommandButtonLabelInfo getShowViewCommandLabel() {
        return this.getLabel();
    }

    public ActionCommand createShowViewCommand(ApplicationWindow window) {
        return new ShowViewCommand(this, window);
    }
}

