/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.command;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import java.awt.Component;
import java.awt.Container;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.command.CommandGroupEvent;
import org.springframework.richclient.command.CommandGroupFactoryBean;
import org.springframework.richclient.command.CommandGroupListener;
import org.springframework.richclient.command.CommandRegistry;
import org.springframework.richclient.command.ComponentGroupMember;
import org.springframework.richclient.command.ExpansionPointGroupMember;
import org.springframework.richclient.command.GlueGroupMember;
import org.springframework.richclient.command.GroupContainerPopulator;
import org.springframework.richclient.command.GroupMember;
import org.springframework.richclient.command.GroupMemberList;
import org.springframework.richclient.command.LazyGroupMember;
import org.springframework.richclient.command.SeparatorGroupMember;
import org.springframework.richclient.command.SimpleGroupMember;
import org.springframework.richclient.command.config.CommandButtonConfigurer;
import org.springframework.richclient.command.config.CommandConfigurer;
import org.springframework.richclient.command.config.CommandFaceDescriptor;
import org.springframework.richclient.command.support.ButtonBarGroupContainerPopulator;
import org.springframework.richclient.command.support.ButtonStackGroupContainerPopulator;
import org.springframework.richclient.command.support.SimpleGroupContainerPopulator;
import org.springframework.richclient.command.support.ToggleButtonPopupListener;
import org.springframework.richclient.factory.ButtonFactory;
import org.springframework.richclient.factory.MenuFactory;
import org.springframework.richclient.util.GuiStandardUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class CommandGroup
extends AbstractCommand {
    private EventListenerList listenerList;
    private GroupMemberList memberList = new GroupMemberList();
    private CommandRegistry commandRegistry;

    public CommandGroup() {
    }

    public CommandGroup(String groupId) {
        super(groupId);
    }

    public CommandGroup(String groupId, CommandFaceDescriptor face) {
        super(groupId, face);
    }

    public CommandGroup(String groupId, CommandRegistry commandRegistry) {
        super(groupId);
        this.setCommandRegistry(commandRegistry);
    }

    public CommandGroup(String id, String encodedLabel) {
        super(id, encodedLabel);
    }

    public CommandGroup(String id, String encodedLabel, Icon icon, String caption) {
        super(id, encodedLabel, icon, caption);
    }

    public static CommandGroup createCommandGroup(AbstractCommand member) {
        return CommandGroup.createCommandGroup(null, new Object[]{member});
    }

    public static CommandGroup createCommandGroup(Object[] members) {
        return CommandGroup.createCommandGroup(null, members, false, null);
    }

    public static CommandGroup createCommandGroup(String groupId, Object[] members) {
        return CommandGroup.createCommandGroup(groupId, members, false, null);
    }

    public static CommandGroup createCommandGroup(String groupId, Object[] members, CommandConfigurer configurer) {
        return CommandGroup.createCommandGroup(groupId, members, false, configurer);
    }

    public static CommandGroup createExclusiveCommandGroup(Object[] members) {
        return CommandGroup.createCommandGroup(null, members, true, null);
    }

    public static CommandGroup createExclusiveCommandGroup(String groupId, Object[] members) {
        return CommandGroup.createCommandGroup(groupId, members, true, null);
    }

    public static CommandGroup createExclusiveCommandGroup(String groupId, Object[] members, CommandConfigurer configurer) {
        return CommandGroup.createCommandGroup(groupId, members, true, configurer);
    }

    private static CommandGroup createCommandGroup(String groupId, Object[] members, boolean exclusive, CommandConfigurer configurer) {
        CommandConfigurer theConfigurer = configurer != null ? configurer : (CommandConfigurer)ApplicationServicesLocator.services().getService(CommandConfigurer.class);
        CommandGroupFactoryBean groupFactory = new CommandGroupFactoryBean(groupId, null, theConfigurer, members);
        groupFactory.setExclusive(exclusive);
        return groupFactory.getCommandGroup();
    }

    protected void addInternal(AbstractCommand command) {
        this.memberList.add(new SimpleGroupMember(this, command));
    }

    protected void addLazyInternal(String commandId) {
        this.memberList.add(new LazyGroupMember(this, commandId));
    }

    protected void addSeparatorInternal() {
        this.memberList.add(new SeparatorGroupMember());
    }

    protected void addGlueInternal() {
        this.memberList.add(new GlueGroupMember());
    }

    protected void addComponentInternal(Component component) {
        this.memberList.add(new ComponentGroupMember(component));
    }

    public final void setCommandRegistry(CommandRegistry registry) {
        if (!ObjectUtils.nullSafeEquals((Object)this.commandRegistry, (Object)registry)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Setting registry " + registry + " for command group '" + this.getId() + "'"));
            }
            this.commandRegistry = registry;
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.getMemberList().setContainersVisible(visible);
    }

    protected CommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    public void add(AbstractCommand command) {
        this.add(command, true);
    }

    public void add(AbstractCommand command, boolean rebuild) {
        if (command == null) {
            return;
        }
        if (this.contains(command)) {
            return;
        }
        this.getMemberList().append(new SimpleGroupMember(this, command));
        this.rebuildIfNecessary(rebuild);
    }

    public void add(String groupMemberPath, AbstractCommand command) {
        AbstractCommand c = this.find(groupMemberPath);
        this.assertIsGroup(groupMemberPath, c);
        ((CommandGroup)c).add(command);
    }

    private void assertIsGroup(String groupMemberPath, AbstractCommand c) {
        Assert.notNull((Object)c, (String)("Command at path '" + groupMemberPath + "' does not exist."));
        Assert.isTrue((boolean)(c instanceof CommandGroup), (String)("Command at path '" + groupMemberPath + "' is not a group."));
    }

    public void add(String groupMemberPath, AbstractCommand command, boolean rebuild) {
        AbstractCommand c = this.find(groupMemberPath);
        this.assertIsGroup(groupMemberPath, c);
        ((CommandGroup)c).add(command, rebuild);
    }

    public void remove(AbstractCommand command) {
        this.remove(command, true);
    }

    public void remove(AbstractCommand command, boolean rebuild) {
        if (command == null) {
            return;
        }
        ExpansionPointGroupMember expansionPoint = this.getMemberList().getExpansionPoint();
        GroupMember member = expansionPoint.getMemberFor(command.getId());
        if (member != null) {
            expansionPoint.remove(member);
            this.rebuildIfNecessary(rebuild);
        }
    }

    public void remove(String groupMemberPath, AbstractCommand command) {
        AbstractCommand c = this.find(groupMemberPath);
        this.assertIsGroup(groupMemberPath, c);
        ((CommandGroup)c).remove(command);
    }

    public void remove(String groupMemberPath, AbstractCommand command, boolean rebuild) {
        AbstractCommand c = this.find(groupMemberPath);
        this.assertIsGroup(groupMemberPath, c);
        ((CommandGroup)c).remove(command, rebuild);
    }

    public void addSeparator() {
        this.addSeparator(true);
    }

    public void addSeparator(boolean rebuild) {
        this.getMemberList().append(new SeparatorGroupMember());
        this.rebuildIfNecessary(rebuild);
    }

    public void addGlue() {
        this.addGlue(true);
    }

    public void addGlue(boolean rebuild) {
        this.getMemberList().append(new GlueGroupMember());
        this.rebuildIfNecessary(rebuild);
    }

    private void rebuildIfNecessary(boolean rebuild) {
        if (rebuild) {
            this.rebuildAllControls();
            this.fireMembersChanged();
        }
    }

    protected void rebuildAllControls() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Rebuilding all GUI controls for command group '" + this.getId() + "'"));
        }
        this.getMemberList().rebuildControls();
    }

    protected GroupMemberList getMemberList() {
        return this.memberList;
    }

    protected Iterator memberIterator() {
        return this.getMemberList().iterator();
    }

    public int size() {
        return this.getMemberCount();
    }

    public boolean isAllowedMember(AbstractCommand proposedMember) {
        return true;
    }

    public AbstractCommand find(String memberPath) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Searching for command with nested path '" + memberPath + "'"));
        }
        String[] paths = StringUtils.delimitedListToStringArray((String)memberPath, (String)"/");
        CommandGroup currentGroup = this;
        for (int i = 0; i < paths.length; ++i) {
            String memberId = paths[i];
            if (i >= paths.length - 1) {
                return currentGroup.findCommandMember(memberId);
            }
            currentGroup = currentGroup.findCommandGroupMember(memberId);
        }
        return null;
    }

    private CommandGroup findCommandGroupMember(String groupId) {
        AbstractCommand c = this.findCommandMember(groupId);
        Assert.isTrue((boolean)(c instanceof CommandGroup), (String)("Command with id '" + groupId + "' is not a group."));
        return (CommandGroup)c;
    }

    private AbstractCommand findCommandMember(String commandId) {
        Iterator it = this.memberList.iterator();
        while (it.hasNext()) {
            GroupMember member = (GroupMember)it.next();
            if (!member.managesCommand(commandId)) continue;
            return member.getCommand();
        }
        this.logger.warn((Object)("No command with id '" + commandId + "' is nested within this group (" + this.getId() + "); returning null"));
        return null;
    }

    public void execute() {
        Iterator it = this.memberList.iterator();
        while (it.hasNext()) {
            GroupMember member = (GroupMember)it.next();
            member.getCommand().execute();
        }
    }

    public int getMemberCount() {
        return this.getMemberList().size();
    }

    public boolean contains(AbstractCommand command) {
        return this.getMemberList().contains(command);
    }

    public void reset() {
        ExpansionPointGroupMember expansionPoint = this.getMemberList().getExpansionPoint();
        if (!expansionPoint.isEmpty()) {
            expansionPoint.clear();
            this.rebuildIfNecessary(true);
        }
    }

    public AbstractButton createButton(String faceDescriptorId, ButtonFactory buttonFactory, CommandButtonConfigurer buttonConfigurer) {
        return this.createButton(this.getDefaultFaceDescriptorId(), buttonFactory, this.getMenuFactory(), buttonConfigurer);
    }

    public AbstractButton createButton(ButtonFactory buttonFactory, MenuFactory menuFactory) {
        return this.createButton(this.getDefaultFaceDescriptorId(), buttonFactory, menuFactory, this.getPullDownMenuButtonConfigurer());
    }

    public AbstractButton createButton(String faceDescriptorId, ButtonFactory buttonFactory, MenuFactory menuFactory) {
        return this.createButton(faceDescriptorId, buttonFactory, menuFactory, this.getPullDownMenuButtonConfigurer());
    }

    public AbstractButton createButton(ButtonFactory buttonFactory, MenuFactory menuFactory, CommandButtonConfigurer buttonConfigurer) {
        return this.createButton(this.getDefaultFaceDescriptorId(), buttonFactory, menuFactory, buttonConfigurer);
    }

    public AbstractButton createButton(String faceDescriptorId, ButtonFactory buttonFactory, MenuFactory menuFactory, CommandButtonConfigurer buttonConfigurer) {
        AbstractButton button = buttonFactory.createToggleButton();
        this.attach(button, buttonConfigurer);
        JPopupMenu popup = menuFactory.createPopupMenu();
        this.bindMembers(button, popup, menuFactory, this.getMenuItemButtonConfigurer());
        ToggleButtonPopupListener.bind(button, popup);
        return button;
    }

    protected CommandButtonConfigurer getPullDownMenuButtonConfigurer() {
        return this.getCommandServices().getPullDownMenuButtonConfigurer();
    }

    public JMenuItem createMenuItem(String faceDescriptorId, MenuFactory factory, CommandButtonConfigurer buttonConfigurer) {
        JMenu menu = factory.createMenu();
        this.attach(menu);
        this.bindMembers(menu, menu, factory, buttonConfigurer);
        return menu;
    }

    public JPopupMenu createPopupMenu() {
        return this.createPopupMenu(this.getMenuFactory());
    }

    public JPopupMenu createPopupMenu(MenuFactory factory) {
        JPopupMenu popup = factory.createPopupMenu();
        this.bindMembers(popup, popup, factory, this.getMenuItemButtonConfigurer());
        return popup;
    }

    public JComponent createToolBar() {
        return this.createToolBar(this.getToolBarButtonFactory());
    }

    public JComponent createToolBar(ButtonFactory buttonFactory) {
        JComponent toolbar = this.getComponentFactory().createToolBar();
        toolbar.setName(this.getText());
        this.bindMembers(toolbar, toolbar, buttonFactory, this.getToolBarButtonConfigurer());
        toolbar.setEnabled(false);
        toolbar.setVisible(true);
        return toolbar;
    }

    public JMenuBar createMenuBar() {
        return this.createMenuBar(this.getMenuFactory());
    }

    public JMenuBar createMenuBar(MenuFactory factory) {
        JMenuBar menubar = factory.createMenuBar();
        this.bindMembers(menubar, menubar, factory, this.getMenuItemButtonConfigurer());
        return menubar;
    }

    public JComponent createButtonBar() {
        return this.createButtonBar(null);
    }

    public JComponent createButtonBar(Size minimumButtonSize) {
        return this.createButtonBar(minimumButtonSize, GuiStandardUtils.createTopAndBottomBorder(11));
    }

    public JComponent createButtonBar(ColumnSpec columnSpec, RowSpec rowSpec) {
        return this.createButtonBar(columnSpec, rowSpec, null);
    }

    public JComponent createButtonBar(Size minimumButtonSize, Border border) {
        return this.createButtonBar(minimumButtonSize == null ? null : new ColumnSpec(minimumButtonSize), null, border);
    }

    public JComponent createButtonBar(ColumnSpec columnSpec, RowSpec rowSpec, Border border) {
        ButtonBarGroupContainerPopulator container = new ButtonBarGroupContainerPopulator();
        container.setColumnSpec(columnSpec);
        container.setRowSpec(rowSpec);
        this.addCommandsToGroupContainer(container);
        return GuiStandardUtils.attachBorder(container.getButtonBar(), border);
    }

    public JComponent createButtonStack() {
        return this.createButtonStack(null);
    }

    public JComponent createButtonStack(Size minimumButtonSize) {
        return this.createButtonStack(minimumButtonSize, GuiStandardUtils.createLeftAndRightBorder(11));
    }

    public JComponent createButtonStack(Size minimumButtonSize, Border border) {
        return this.createButtonStack(minimumButtonSize == null ? null : new ColumnSpec(minimumButtonSize), null, border);
    }

    public JComponent createButtonStack(ColumnSpec columnSpec, RowSpec rowSpec) {
        return this.createButtonStack(columnSpec, rowSpec, null);
    }

    public JComponent createButtonStack(ColumnSpec columnSpec, RowSpec rowSpec, Border border) {
        ButtonStackGroupContainerPopulator container = new ButtonStackGroupContainerPopulator();
        container.setColumnSpec(columnSpec);
        container.setRowSpec(rowSpec);
        this.addCommandsToGroupContainer(container);
        return GuiStandardUtils.attachBorder(container.getButtonStack(), border);
    }

    protected void addCommandsToGroupContainer(GroupContainerPopulator groupContainerPopulator) {
        Iterator members = this.getMemberList().iterator();
        while (members.hasNext()) {
            GroupMember member = (GroupMember)members.next();
            if (member.getCommand() instanceof CommandGroup) {
                member.fill(groupContainerPopulator, this.getButtonFactory(), this.getPullDownMenuButtonConfigurer(), Collections.EMPTY_LIST);
                continue;
            }
            member.fill(groupContainerPopulator, this.getButtonFactory(), this.getDefaultButtonConfigurer(), Collections.EMPTY_LIST);
        }
        groupContainerPopulator.onPopulated();
    }

    private void bindMembers(Object owner, Container memberContainer, Object controlFactory, CommandButtonConfigurer configurer) {
        this.getMemberList().bindMembers(owner, new SimpleGroupContainerPopulator(memberContainer), controlFactory, configurer);
    }

    public void addGroupListener(CommandGroupListener l) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(CommandGroupListener.class, l);
    }

    public void removeGroupListener(CommandGroupListener l) {
        Assert.notNull((Object)this.listenerList, (String)"Listener list has not yet been instantiated!");
        this.listenerList.remove(CommandGroupListener.class, l);
    }

    protected void fireMembersChanged() {
        if (this.listenerList == null) {
            return;
        }
        CommandGroupEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$springframework$richclient$command$CommandGroupListener == null ? CommandGroup.class$("org.springframework.richclient.command.CommandGroupListener") : class$org$springframework$richclient$command$CommandGroupListener)) continue;
            if (event == null) {
                event = new CommandGroupEvent(this);
            }
            ((CommandGroupListener)listeners[i + 1]).membersChanged(event);
        }
    }
}

