/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.command;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.richclient.command.ToggleCommand;

public class ExclusiveCommandGroupSelectionController {
    private List commands = new ArrayList();
    private boolean allowsEmptySelection;

    public boolean getAllowsEmptySelection() {
        return this.allowsEmptySelection;
    }

    public void setAllowsEmptySelection(boolean allowsEmptySelection) {
        this.allowsEmptySelection = allowsEmptySelection;
    }

    public void add(ToggleCommand command) {
        if (!this.commands.contains(command)) {
            this.commands.add(command);
            command.setExclusiveController(this);
        }
    }

    public void remove(ToggleCommand command) {
        if (this.commands.remove(command)) {
            command.setExclusiveController(null);
        }
    }

    public void handleSelectionRequest(ToggleCommand delegatingCommand, boolean requestingSelection) {
        if (requestingSelection) {
            ToggleCommand currentSelectedCommand = null;
            Iterator iterator = this.commands.iterator();
            while (iterator.hasNext()) {
                ToggleCommand command = (ToggleCommand)iterator.next();
                if (!command.isSelected()) continue;
                currentSelectedCommand = command;
                break;
            }
            if (currentSelectedCommand == null) {
                delegatingCommand.requestSetSelection(true);
            } else {
                currentSelectedCommand.requestSetSelection(false);
                delegatingCommand.requestSetSelection(!currentSelectedCommand.isSelected());
                if (!delegatingCommand.isSelected() && currentSelectedCommand != null) {
                    currentSelectedCommand.requestSetSelection(true);
                }
            }
        } else if (this.allowsEmptySelection) {
            delegatingCommand.requestSetSelection(false);
        }
    }
}

