/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.command.ExpansionPointGroupMember;
import org.springframework.richclient.command.GroupContainerPopulator;
import org.springframework.richclient.command.GroupMember;
import org.springframework.richclient.command.GroupMemberContainerManager;
import org.springframework.richclient.command.config.CommandButtonConfigurer;

public class GroupMemberList {
    private static final Log logger = LogFactory.getLog((Class)GroupMemberList.class);
    private List members = new ArrayList(9);
    private Map builders = new WeakHashMap(6);
    private ExpansionPointGroupMember expansionPoint;

    public void add(GroupMember member) {
        if (this.members.add(member)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Member '" + member + "' added to memberList"));
            }
            member.onAdded();
        }
    }

    public void append(GroupMember member) {
        this.getExpansionPoint().add(member);
    }

    public ExpansionPointGroupMember getExpansionPoint() {
        if (this.expansionPoint == null) {
            this.expansionPoint = new ExpansionPointGroupMember();
            this.add(this.expansionPoint);
        }
        return this.expansionPoint;
    }

    public int size() {
        return this.members.size();
    }

    public Iterator iterator() {
        return Collections.unmodifiableList(this.members).iterator();
    }

    public void setContainersVisible(boolean visible) {
        Iterator it = this.builders.values().iterator();
        while (it.hasNext()) {
            GroupMemberContainerManager gcm = (GroupMemberContainerManager)it.next();
            gcm.setVisible(visible);
        }
    }

    protected void bindMembers(Object owner, GroupContainerPopulator container, Object factory, CommandButtonConfigurer configurer) {
        GroupMemberContainerManager builder = new GroupMemberContainerManager(container, factory, configurer);
        builder.rebuildControlsFor(this.members);
        this.builders.put(owner, builder);
    }

    protected void rebuildControls() {
        Iterator iter = this.builders.values().iterator();
        while (iter.hasNext()) {
            GroupMemberContainerManager builder = (GroupMemberContainerManager)iter.next();
            if (builder == null) continue;
            builder.rebuildControlsFor(this.members);
        }
    }

    public boolean contains(AbstractCommand command) {
        for (int i = 0; i < this.members.size(); ++i) {
            GroupMember member = (GroupMember)this.members.get(i);
            if (!member.managesCommand(command.getId())) continue;
            return true;
        }
        return false;
    }
}

