/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.command;

import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.RootPaneContainer;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.command.ExclusiveCommandGroupSelectionController;
import org.springframework.richclient.command.config.CommandButtonConfigurer;
import org.springframework.richclient.command.config.CommandFaceDescriptor;
import org.springframework.richclient.factory.ButtonFactory;
import org.springframework.richclient.factory.MenuFactory;
import org.springframework.util.Assert;

public abstract class ToggleCommand
extends ActionCommand {
    public static final String SELECTED_PROPERTY = "selected";
    private boolean selected;
    private ExclusiveCommandGroupSelectionController exclusiveController;

    public ToggleCommand() {
    }

    public ToggleCommand(String commandId) {
        super(commandId);
    }

    public ToggleCommand(String id, CommandFaceDescriptor face) {
        super(id, face);
    }

    public ToggleCommand(String id, String encodedLabel) {
        super(id, encodedLabel);
    }

    public ToggleCommand(String id, String encodedLabel, Icon icon, String caption) {
        super(id, encodedLabel, icon, caption);
    }

    public void setExclusiveController(ExclusiveCommandGroupSelectionController exclusiveController) {
        this.exclusiveController = exclusiveController;
    }

    public boolean isExclusiveGroupMember() {
        return this.exclusiveController != null;
    }

    public JMenuItem createMenuItem(String faceDescriptorId, MenuFactory factory, CommandButtonConfigurer buttonConfigurer) {
        JMenuItem menuItem = this.isExclusiveGroupMember() ? factory.createRadioButtonMenuItem() : factory.createCheckBoxMenuItem();
        this.attach(menuItem, faceDescriptorId, buttonConfigurer);
        return menuItem;
    }

    public AbstractButton createButton(String faceDescriptorId, ButtonFactory buttonFactory, CommandButtonConfigurer configurer) {
        AbstractButton button = buttonFactory.createToggleButton();
        this.attach(button, faceDescriptorId, configurer);
        return button;
    }

    public final AbstractButton createCheckBox() {
        return this.createCheckBox(this.getDefaultFaceDescriptorId(), this.getButtonFactory(), this.getDefaultButtonConfigurer());
    }

    public final AbstractButton createCheckBox(ButtonFactory buttonFactory) {
        return this.createCheckBox(this.getDefaultFaceDescriptorId(), buttonFactory, this.getDefaultButtonConfigurer());
    }

    public final AbstractButton createCheckBox(String faceDescriptorId, ButtonFactory buttonFactory) {
        return this.createCheckBox(faceDescriptorId, buttonFactory, this.getDefaultButtonConfigurer());
    }

    public AbstractButton createCheckBox(String faceDescriptorId, ButtonFactory buttonFactory, CommandButtonConfigurer configurer) {
        AbstractButton checkBox = buttonFactory.createCheckBox();
        this.attach(checkBox, configurer);
        return checkBox;
    }

    public final AbstractButton createRadioButton() {
        return this.createRadioButton(this.getDefaultFaceDescriptorId(), this.getButtonFactory(), this.getDefaultButtonConfigurer());
    }

    public final AbstractButton createRadioButton(ButtonFactory buttonFactory) {
        return this.createRadioButton(this.getDefaultFaceDescriptorId(), buttonFactory, this.getDefaultButtonConfigurer());
    }

    public final AbstractButton createRadioButton(String faceDescriptorId, ButtonFactory buttonFactory) {
        return this.createRadioButton(faceDescriptorId, buttonFactory, this.getDefaultButtonConfigurer());
    }

    public AbstractButton createRadioButton(String faceDescriptorId, ButtonFactory buttonFactory, CommandButtonConfigurer configurer) {
        Assert.state((boolean)this.isExclusiveGroupMember(), (String)"Can't create radio buttons for toggle commands that aren't members of an exclusive group");
        AbstractButton radioButton = buttonFactory.createRadioButton();
        this.attach(radioButton, faceDescriptorId, configurer);
        return radioButton;
    }

    protected void onButtonAttached(AbstractButton button) {
        super.onButtonAttached(button);
        button.setSelected(this.selected);
    }

    public final boolean isSelected() {
        return this.selected;
    }

    public final void setSelected(boolean selected) {
        if (this.isExclusiveGroupMember()) {
            boolean oldState = this.isSelected();
            this.exclusiveController.handleSelectionRequest(this, selected);
            if (oldState == this.isSelected()) {
                Iterator iter = this.buttonIterator();
                while (iter.hasNext()) {
                    AbstractButton button = (AbstractButton)iter.next();
                    button.setSelected(this.isSelected());
                }
            }
        } else {
            this.requestSetSelection(selected);
        }
    }

    protected boolean requestSetSelection(boolean selected) {
        boolean previousState = this.isSelected();
        if (previousState != selected) {
            this.selected = this.onSelection(selected);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Toggle command selection returned '" + this.selected + "'"));
            }
        }
        Iterator it = this.buttonIterator();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Updating all attached toggle buttons to '" + this.isSelected() + "'"));
        }
        while (it.hasNext()) {
            AbstractButton button = (AbstractButton)it.next();
            button.setSelected(this.isSelected());
        }
        if (previousState != this.isSelected()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Selection changed; firing property change event");
            }
            this.firePropertyChange(SELECTED_PROPERTY, previousState, this.isSelected());
        }
        return this.isSelected();
    }

    protected final void doExecuteCommand() {
        this.setSelected(!this.isSelected());
    }

    protected boolean onSelection(boolean selected) {
        if (selected) {
            this.onSelection();
        } else {
            this.onDeselection();
        }
        return selected;
    }

    protected void onSelection() {
    }

    protected void onDeselection() {
    }

    public void requestDefaultIn(RootPaneContainer container) {
        throw new UnsupportedOperationException();
    }
}

