/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.command.config;

import java.awt.Image;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.springframework.core.style.ToStringCreator;
import org.springframework.richclient.core.VisualizedElement;
import org.springframework.richclient.factory.ButtonConfigurer;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class CommandButtonIconInfo
implements ButtonConfigurer,
VisualizedElement {
    public static final CommandButtonIconInfo BLANK_ICON_INFO = new CommandButtonIconInfo(null);
    private Icon icon;
    private Icon selectedIcon;
    private Icon disabledIcon;
    private Icon pressedIcon;
    private Icon rolloverIcon;

    public CommandButtonIconInfo(Icon icon) {
        this.icon = icon;
    }

    public CommandButtonIconInfo(Icon icon, Icon selectedIcon) {
        this.icon = icon;
        this.selectedIcon = selectedIcon;
    }

    public CommandButtonIconInfo(Icon icon, Icon selectedIcon, Icon rolloverIcon) {
        this.icon = icon;
        this.selectedIcon = selectedIcon;
        this.rolloverIcon = rolloverIcon;
    }

    public CommandButtonIconInfo(Icon icon, Icon selectedIcon, Icon rolloverIcon, Icon disabledIcon, Icon pressedIcon) {
        this.icon = icon;
        this.selectedIcon = selectedIcon;
        this.rolloverIcon = rolloverIcon;
        this.disabledIcon = disabledIcon;
        this.pressedIcon = pressedIcon;
    }

    public AbstractButton configure(AbstractButton button) {
        Assert.notNull((Object)button, (String)"The button to configure is required");
        button.setIcon(this.icon);
        button.setSelectedIcon(this.selectedIcon);
        button.setDisabledIcon(this.disabledIcon);
        button.setPressedIcon(this.pressedIcon);
        button.setRolloverIcon(this.rolloverIcon);
        return button;
    }

    public Image getImage() {
        if (this.getIcon() instanceof ImageIcon) {
            return ((ImageIcon)this.getIcon()).getImage();
        }
        return null;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Icon getDisabledIcon() {
        return this.disabledIcon;
    }

    public Icon getPressedIcon() {
        return this.pressedIcon;
    }

    public Icon getRolloverIcon() {
        return this.rolloverIcon;
    }

    public Icon getSelectedIcon() {
        return this.selectedIcon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public void setDisabledIcon(Icon disabledIcon) {
        this.disabledIcon = disabledIcon;
    }

    public void setPressedIcon(Icon pressedIcon) {
        this.pressedIcon = pressedIcon;
    }

    public void setRolloverIcon(Icon rolloverIcon) {
        this.rolloverIcon = rolloverIcon;
    }

    public void setSelectedIcon(Icon selectedIcon) {
        this.selectedIcon = selectedIcon;
    }

    public String toString() {
        return new ToStringCreator((Object)this).toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof CommandButtonIconInfo)) {
            return false;
        }
        CommandButtonIconInfo other = (CommandButtonIconInfo)o;
        return ObjectUtils.nullSafeEquals((Object)this.icon, (Object)other.icon) && ObjectUtils.nullSafeEquals((Object)this.disabledIcon, (Object)other.disabledIcon) && ObjectUtils.nullSafeEquals((Object)this.pressedIcon, (Object)other.pressedIcon) && ObjectUtils.nullSafeEquals((Object)this.rolloverIcon, (Object)other.rolloverIcon) && ObjectUtils.nullSafeEquals((Object)this.selectedIcon, (Object)other.selectedIcon);
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + (this.icon == null ? 0 : this.icon.hashCode());
        hash = hash * 31 + (this.disabledIcon == null ? 0 : this.disabledIcon.hashCode());
        hash = hash * 31 + (this.pressedIcon == null ? 0 : this.pressedIcon.hashCode());
        hash = hash * 31 + (this.rolloverIcon == null ? 0 : this.rolloverIcon.hashCode());
        hash = hash * 31 + (this.selectedIcon == null ? 0 : this.selectedIcon.hashCode());
        return hash;
    }
}

