/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.command.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.application.config.ApplicationObjectConfigurer;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.command.CommandServices;
import org.springframework.richclient.command.config.CommandConfigurer;
import org.springframework.richclient.command.config.CommandFaceDescriptor;
import org.springframework.richclient.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class DefaultCommandConfigurer
implements CommandConfigurer {
    private final Log logger = LogFactory.getLog(this.getClass());
    private CommandServices commandServices;
    private ApplicationObjectConfigurer objectConfigurer;

    public DefaultCommandConfigurer() {
    }

    public DefaultCommandConfigurer(CommandServices commandServices) {
        this.setCommandServices(commandServices);
    }

    public void setApplicationObjectConfigurer(ApplicationObjectConfigurer configurer) {
        this.objectConfigurer = configurer;
    }

    public void setCommandServices(CommandServices services) {
        this.commandServices = services;
    }

    public AbstractCommand configure(AbstractCommand command) {
        Assert.required((Object)command, (String)"command");
        return this.configure(command, this.getObjectConfigurer());
    }

    protected ApplicationObjectConfigurer getObjectConfigurer() {
        if (this.objectConfigurer == null) {
            this.objectConfigurer = (ApplicationObjectConfigurer)ApplicationServicesLocator.services().getService(ApplicationObjectConfigurer.class);
        }
        return this.objectConfigurer;
    }

    public AbstractCommand configure(AbstractCommand command, ApplicationObjectConfigurer configurer) {
        int lastDot;
        command.setCommandServices(this.getCommandServices());
        String objectName = command.getId();
        if (command.isAnonymous() && (lastDot = (objectName = ClassUtils.getShortNameAsProperty(command.getClass())).lastIndexOf(46)) != -1) {
            objectName = StringUtils.uncapitalize((String)objectName.substring(lastDot + 1));
        }
        configurer.configure(command, objectName);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Configuring faces (aka visual appearance descriptors) for " + command));
        }
        CommandFaceDescriptor face = new CommandFaceDescriptor();
        configurer.configure(face, objectName);
        command.setFaceDescriptor(face);
        return command;
    }

    protected CommandServices getCommandServices() {
        if (this.commandServices == null) {
            this.commandServices = (CommandServices)ApplicationServicesLocator.services().getService(CommandServices.class);
        }
        return this.commandServices;
    }
}

