/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.command.support;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.richclient.application.ApplicationWindow;
import org.springframework.richclient.application.PageDescriptor;
import org.springframework.richclient.application.PropertyNotSetException;
import org.springframework.richclient.command.support.ApplicationWindowAwareCommand;
import org.springframework.richclient.util.Assert;

public class ShowPageCommand
extends ApplicationWindowAwareCommand
implements InitializingBean {
    private PageDescriptor pageDescriptor;

    public ShowPageCommand() {
    }

    public ShowPageCommand(PageDescriptor pageDescriptor, ApplicationWindow applicationWindow) {
        Assert.required((Object)applicationWindow, (String)"applicationWindow");
        this.setPageDescriptor(pageDescriptor);
        this.setApplicationWindow(applicationWindow);
        this.setEnabled(true);
    }

    public void afterPropertiesSet() {
        PropertyNotSetException.throwIfNull((Object)this.getApplicationWindow(), (String)"applicationWindow", this.getClass());
        PropertyNotSetException.throwIfNull((Object)this.pageDescriptor, (String)"pageDescriptor", this.getClass());
    }

    public final void setPageDescriptor(PageDescriptor pageDescriptor) {
        Assert.required((Object)pageDescriptor, (String)"pageDescriptor");
        this.setId(pageDescriptor.getId());
        this.setLabel(pageDescriptor.getShowPageCommandLabel());
        this.setIcon(pageDescriptor.getIcon());
        this.setCaption(pageDescriptor.getCaption());
        this.pageDescriptor = pageDescriptor;
    }

    protected void doExecuteCommand() {
        this.getApplicationWindow().showPage(this.pageDescriptor);
    }
}

