/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.command.support;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.richclient.application.ApplicationWindow;
import org.springframework.richclient.application.PropertyNotSetException;
import org.springframework.richclient.application.ViewDescriptor;
import org.springframework.richclient.command.support.ApplicationWindowAwareCommand;
import org.springframework.richclient.util.Assert;

public class ShowViewCommand
extends ApplicationWindowAwareCommand
implements InitializingBean {
    private ViewDescriptor viewDescriptor;

    public ShowViewCommand() {
    }

    public ShowViewCommand(ViewDescriptor viewDescriptor, ApplicationWindow applicationWindow) {
        Assert.required((Object)applicationWindow, (String)"applicationWindow");
        this.setViewDescriptor(viewDescriptor);
        this.setApplicationWindow(applicationWindow);
        this.setEnabled(true);
    }

    public void afterPropertiesSet() {
        PropertyNotSetException.throwIfNull((Object)this.getApplicationWindow(), (String)"applicationWindow", this.getClass());
        PropertyNotSetException.throwIfNull((Object)this.viewDescriptor, (String)"viewDescriptor", this.getClass());
    }

    public final void setViewDescriptor(ViewDescriptor viewDescriptor) {
        Assert.required((Object)viewDescriptor, (String)"viewDescriptor");
        this.setId(viewDescriptor.getId());
        this.setLabel(viewDescriptor.getShowViewCommandLabel());
        this.setIcon(viewDescriptor.getIcon());
        this.setCaption(viewDescriptor.getCaption());
        this.viewDescriptor = viewDescriptor;
    }

    protected void doExecuteCommand() {
        this.getApplicationWindow().getPage().showView(this.viewDescriptor);
    }
}

