/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.springframework.richclient.factory.AbstractControlFactory;
import org.springframework.richclient.util.GuiStandardUtils;
import org.springframework.util.Assert;

public class ListItemUpDownButtonPanel
extends AbstractControlFactory {
    private static final String DOWN_BUTTON_MESSAGE_CODE = "button.down";
    private static final String UP_BUTTON_MESSAGE_CODE = "button.up";
    private final ListSelectionListener listSelectionChangeHandler = new ListSelectionChangeHandler();
    private final UpAction upAction = new UpAction();
    private final DownAction downAction = new DownAction();
    private final JList list;
    private JButton upButton;
    private JButton downButton;

    public ListItemUpDownButtonPanel(JList list) {
        this.list = list;
        Assert.isTrue((boolean)(list.getModel() instanceof List), (String)"List model must implement the List collection interface");
        this.subscribe();
    }

    protected JList getList() {
        return this.list;
    }

    protected List getListModel() {
        return (List)((Object)this.list.getModel());
    }

    protected JComponent createControl() {
        return this.createUpDownButtonPanel();
    }

    private void subscribe() {
        this.list.addListSelectionListener(this.listSelectionChangeHandler);
    }

    protected void onEmptySelection() {
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
    }

    protected void onSelection() {
        if (!this.isContiguousSelection(this.getList())) {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        } else {
            if (this.getList().getMinSelectionIndex() == 0) {
                this.upButton.setEnabled(false);
            } else {
                this.upButton.setEnabled(true);
            }
            if (this.getList().getMaxSelectionIndex() == this.getListModel().size() - 1) {
                this.downButton.setEnabled(false);
            } else {
                this.downButton.setEnabled(true);
            }
        }
    }

    private boolean isContiguousSelection(JList list) {
        for (int i = list.getMinSelectionIndex(); i <= list.getMaxSelectionIndex(); ++i) {
            if (list.isSelectedIndex(i)) continue;
            return false;
        }
        return true;
    }

    private JComponent createUpDownButtonPanel() {
        this.upButton = this.getComponentFactory().createButton(UP_BUTTON_MESSAGE_CODE);
        this.upButton.setEnabled(false);
        this.upButton.addActionListener(this.upAction);
        this.downButton = this.getComponentFactory().createButton(DOWN_BUTTON_MESSAGE_CODE);
        this.downButton.setEnabled(false);
        this.downButton.addActionListener(this.downAction);
        JComponent panel = GuiStandardUtils.createCommandButtonColumn(new JButton[]{this.upButton, this.downButton});
        panel.setBorder(GuiStandardUtils.createLeftAndRightBorder(5));
        return panel;
    }

    private class UpAction
    implements ActionListener {
        private UpAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int[] indices = ListItemUpDownButtonPanel.this.getList().getSelectedIndices();
            Object[] array = new Object[indices.length];
            Arrays.sort(indices);
            if (indices[0] == 0) {
                return;
            }
            List model = ListItemUpDownButtonPanel.this.getListModel();
            for (int i = 0; i < indices.length; ++i) {
                array[i] = model.get(indices[i] - i);
                model.remove(indices[i] - i);
            }
            int[] newIndices = new int[indices.length];
            for (int i = 0; i < indices.length; ++i) {
                int newIndex = indices[0] - 1 + i;
                model.add(newIndex, array[i]);
                newIndices[i] = newIndex;
            }
            ListItemUpDownButtonPanel.this.getList().setSelectedIndices(newIndices);
        }
    }

    private class DownAction
    implements ActionListener {
        private DownAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int[] indices = ListItemUpDownButtonPanel.this.getList().getSelectedIndices();
            Object[] array = new Object[indices.length];
            Arrays.sort(indices);
            List model = ListItemUpDownButtonPanel.this.getListModel();
            if (indices[indices.length - 1] == model.size() - 1) {
                return;
            }
            for (int i = 0; i < indices.length; ++i) {
                array[i] = model.get(indices[i] - i);
                model.remove(indices[i] - i);
            }
            int[] newIndices = new int[indices.length];
            for (int i = 0; i < indices.length; ++i) {
                int newIndex = indices[0] + 1 + i;
                model.add(newIndex, array[i]);
                newIndices[i] = newIndex;
            }
            ListItemUpDownButtonPanel.this.getList().setSelectedIndices(newIndices);
        }
    }

    private class ListSelectionChangeHandler
    implements ListSelectionListener {
        private ListSelectionChangeHandler() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (ListItemUpDownButtonPanel.this.list.isSelectionEmpty()) {
                    ListItemUpDownButtonPanel.this.onEmptySelection();
                } else {
                    ListItemUpDownButtonPanel.this.onSelection();
                }
            }
        }
    }
}

