/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.core;

import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.event.SwingPropertyChangeSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.style.ToStringCreator;
import org.springframework.richclient.application.support.ApplicationServicesAccessor;
import org.springframework.richclient.command.config.CommandButtonLabelInfo;
import org.springframework.richclient.command.config.CommandLabelConfigurable;
import org.springframework.richclient.core.DescribedElement;
import org.springframework.richclient.core.DescriptionConfigurable;
import org.springframework.richclient.core.TitleConfigurable;
import org.springframework.richclient.core.VisualizedElement;
import org.springframework.richclient.image.config.ImageConfigurable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class LabeledObjectSupport
extends ApplicationServicesAccessor
implements DescribedElement,
VisualizedElement,
CommandLabelConfigurable,
ImageConfigurable,
DescriptionConfigurable,
TitleConfigurable {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private CommandButtonLabelInfo label;
    private String title;
    private String caption;
    private String description;
    private Image image;
    private PropertyChangeSupport propertyChangeSupport;

    public void setLabelInfo(CommandButtonLabelInfo label) {
        String oldDisplayName = null;
        if (this.title != null || this.label != null) {
            oldDisplayName = this.getDisplayName();
        }
        int oldMnemonic = this.getMnemonic();
        int oldMnemonicIndex = this.getMnemonicIndex();
        KeyStroke oldAccelerator = this.getAccelerator();
        this.label = label;
        this.firePropertyChange("displayName", oldDisplayName, this.getDisplayName());
        this.firePropertyChange("mnemonic", oldMnemonic, this.getMnemonic());
        this.firePropertyChange("mnemonicIndex", oldMnemonicIndex, this.getMnemonicIndex());
        this.firePropertyChange("accelerator", oldAccelerator, this.getAccelerator());
    }

    public void setCaption(String caption) {
        String oldValue = caption;
        this.caption = caption;
        this.firePropertyChange("caption", oldValue, caption);
    }

    public void setDescription(String description) {
        String oldValue = this.description;
        this.description = description;
        this.firePropertyChange("description", oldValue, description);
    }

    public void setTitle(String title) {
        String oldValue = null;
        if (this.title != null || this.label != null) {
            oldValue = this.getDisplayName();
        }
        this.title = title;
        this.firePropertyChange("displayName", oldValue, this.getDisplayName());
    }

    public void setImage(Image image) {
        Image oldValue = image;
        this.image = image;
        this.firePropertyChange("image", oldValue, image);
    }

    public String getDisplayName() {
        if (this.title != null) {
            return this.title;
        }
        if (this.label == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"This labeled object's display name is not configured; returning 'displayName'");
            }
            return "displayName";
        }
        return this.label.getText();
    }

    public String getCaption() {
        return this.caption;
    }

    public String getDescription() {
        return this.description;
    }

    public Image getImage() {
        return this.image;
    }

    public Icon getIcon() {
        if (this.image != null) {
            return new ImageIcon(this.image);
        }
        return null;
    }

    public int getMnemonic() {
        if (this.label != null) {
            return this.label.getMnemonic();
        }
        return 0;
    }

    public int getMnemonicIndex() {
        if (this.label != null) {
            return this.label.getMnemonicIndex();
        }
        return 0;
    }

    public KeyStroke getAccelerator() {
        if (this.label != null) {
            return this.label.getAccelerator();
        }
        return null;
    }

    public CommandButtonLabelInfo getLabel() {
        return this.label;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getOrCreatePropertyChangeSupport().addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.getOrCreatePropertyChangeSupport().addPropertyChangeListener(propertyName, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.getPropertyChangeSupport().removePropertyChangeListener(l);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.getPropertyChangeSupport().removePropertyChangeListener(propertyName, l);
    }

    private PropertyChangeSupport getPropertyChangeSupport() {
        Assert.notNull((Object)this.propertyChangeSupport, (String)"Property change support has not yet been initialized; add a listener first!");
        return this.propertyChangeSupport;
    }

    private PropertyChangeSupport getOrCreatePropertyChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new SwingPropertyChangeSupport(this);
        }
        return this.propertyChangeSupport;
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected boolean hasChanged(Object currentValue, Object proposedValue) {
        return !ObjectUtils.nullSafeEquals((Object)currentValue, (Object)proposedValue);
    }

    protected boolean hasChanged(boolean currentValue, boolean proposedValue) {
        return currentValue != proposedValue;
    }

    protected boolean hasChanged(int currentValue, int proposedValue) {
        return currentValue != proposedValue;
    }

    public String toString() {
        return new ToStringCreator((Object)this).toString();
    }
}

