/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.dialog;

import java.awt.Image;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.springframework.richclient.core.Guarded;
import org.springframework.richclient.core.LabeledObjectSupport;
import org.springframework.richclient.core.Message;
import org.springframework.richclient.dialog.DefaultMessageAreaModel;
import org.springframework.richclient.dialog.DialogPage;
import org.springframework.richclient.factory.AbstractControlFactory;
import org.springframework.richclient.factory.ControlFactory;
import org.springframework.richclient.image.config.IconConfigurable;
import org.springframework.util.Assert;

public abstract class AbstractDialogPage
extends LabeledObjectSupport
implements DialogPage,
ControlFactory,
Guarded,
IconConfigurable {
    private final MessageChangeHandler messageChangeHandler = new MessageChangeHandler();
    private String pageId;
    private Icon icon;
    private boolean pageComplete = true;
    private DefaultMessageAreaModel messageBuffer;
    private boolean visible = true;
    private AbstractControlFactory factory = new AbstractControlFactory(){

        public JComponent createControl() {
            return AbstractDialogPage.this.createControl();
        }
    };

    protected AbstractDialogPage(String pageId) {
        this(pageId, true);
    }

    protected AbstractDialogPage(String pageId, boolean autoConfigure) {
        this.messageBuffer = new DefaultMessageAreaModel(this);
        this.messageBuffer.addPropertyChangeListener(this.messageChangeHandler);
        this.setId(pageId, autoConfigure);
    }

    protected AbstractDialogPage(String pageId, boolean autoConfigure, String title) {
        this(pageId, autoConfigure);
        if (title != null) {
            this.setTitle(title);
        }
    }

    protected AbstractDialogPage(String pageId, boolean autoConfigure, String title, Image icon) {
        this(pageId, autoConfigure, title);
        if (icon != null) {
            this.setImage(icon);
        }
    }

    public String getId() {
        return this.pageId;
    }

    protected void setId(String pageId, boolean autoConfigure) {
        Assert.hasText((String)pageId, (String)"pageId is required");
        String oldValue = this.pageId;
        this.pageId = pageId;
        this.firePropertyChange("id", oldValue, pageId);
        if (autoConfigure) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Auto configuring dialog page with id " + pageId));
            }
            this.getObjectConfigurer().configure(this, pageId);
        }
    }

    public String getTitle() {
        return this.getDisplayName();
    }

    public Message getMessage() {
        return this.messageBuffer.getMessage();
    }

    public void setMessage(Message newMessage) {
        this.messageBuffer.setMessage(newMessage);
    }

    public boolean hasErrorMessage() {
        return this.messageBuffer.hasErrorMessage();
    }

    public boolean hasWarningMessage() {
        return this.messageBuffer.hasWarningMessage();
    }

    public boolean hasInfoMessage() {
        return this.messageBuffer.hasInfoMessage();
    }

    public void setVisible(boolean visible) {
        boolean oldValue = this.visible;
        this.getControl().setVisible(visible);
        this.visible = visible;
        this.firePropertyChange("visible", oldValue, visible);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isPageComplete() {
        return this.pageComplete;
    }

    public void setPageComplete(boolean pageComplete) {
        boolean oldValue = this.pageComplete;
        this.pageComplete = pageComplete;
        this.firePropertyChange("pageComplete", oldValue, pageComplete);
    }

    public boolean isEnabled() {
        return this.isPageComplete();
    }

    public void setEnabled(boolean enabled) {
        this.setPageComplete(enabled);
    }

    public JComponent getControl() {
        return this.factory.getControl();
    }

    public boolean isControlCreated() {
        return this.factory.isControlCreated();
    }

    public Window getParentWindowControl() {
        return SwingUtilities.getWindowAncestor(this.getControl());
    }

    public void performHelp() {
    }

    protected abstract JComponent createControl();

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Icon getIcon() {
        return this.icon;
    }

    private class MessageChangeHandler
    implements PropertyChangeListener {
        private MessageChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            AbstractDialogPage.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }
}

