/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLDocument;
import org.springframework.richclient.core.Message;
import org.springframework.richclient.core.Severity;
import org.springframework.richclient.dialog.DefaultMessageAreaModel;
import org.springframework.richclient.dialog.Messagable;
import org.springframework.richclient.dialog.MessagePane;
import org.springframework.richclient.factory.AbstractControlFactory;
import org.springframework.richclient.text.HtmlPane;
import org.springframework.richclient.util.GuiStandardUtils;
import org.springframework.util.StringUtils;

public class AlertMessageAreaPane
extends AbstractControlFactory
implements MessagePane,
PropertyChangeListener {
    private Icon warningIcon;
    private Icon errorIcon;
    private Icon infoIcon;
    private HtmlPane messageArea;
    private JLabel iconLabel;
    private DefaultMessageAreaModel messageAreaModel;

    public AlertMessageAreaPane() {
        this.init(this);
    }

    public AlertMessageAreaPane(Messagable delegate) {
        this.init(delegate);
    }

    private void init(Messagable delegate) {
        this.messageAreaModel = new DefaultMessageAreaModel(delegate);
        this.messageAreaModel.addPropertyChangeListener(this);
        this.iconLabel = new JLabel();
        this.messageArea = new HtmlPane();
        Font defaultFont = UIManager.getFont("Button.font");
        String stylesheet = "body {  font-family: " + defaultFont.getName() + "; font-size: " + defaultFont.getSize() + "pt;  }" + "a, p, li { font-family: " + defaultFont.getName() + "; font-size: " + defaultFont.getSize() + "pt;  }";
        try {
            ((HTMLDocument)this.messageArea.getDocument()).getStyleSheet().loadRules(new StringReader(stylesheet), null);
        }
        catch (IOException e) {
            // empty catch block
        }
        GuiStandardUtils.textComponentAsLabel(this.messageArea);
        this.messageArea.setFont(new JLabel().getFont());
        this.messageArea.setFocusable(false);
    }

    public int getPreferredHeight() {
        return this.messageArea.getPreferredSize().height;
    }

    protected JComponent createControl() {
        JPanel panel = new JPanel(new BorderLayout(11, 0));
        panel.add((Component)this.iconLabel, "Before");
        panel.add(this.messageArea);
        return panel;
    }

    public Message getMessage() {
        return this.messageAreaModel.getMessage();
    }

    public void setMessage(Message message) {
        this.messageAreaModel.setMessage(message);
    }

    public boolean isMessageShowing() {
        if (this.messageArea == null) {
            return false;
        }
        return StringUtils.hasText((String)this.messageArea.getText()) && this.messageArea.isVisible();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.messageAreaModel.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.messageAreaModel.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.messageAreaModel.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.messageAreaModel.removePropertyChangeListener(propertyName, listener);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.update(this.getMessage());
    }

    private void update(Message message) {
        String text = message.getMessage();
        String[] parts = message.getMessage().split("\\n");
        if (parts.length > 1) {
            StringBuffer sb = new StringBuffer();
            sb.append("<html>");
            sb.append("<b>");
            sb.append(parts[0]);
            sb.append("</b>");
            for (int i = 1; i < parts.length; ++i) {
                sb.append("<p>");
                sb.append(parts[i]);
            }
            text = sb.toString();
        }
        this.messageArea.setText(text);
        this.iconLabel.setIcon(this.getIcon(message.getSeverity()));
    }

    private Icon getIcon(Severity severity) {
        if (severity == Severity.ERROR) {
            return this.getErrorIcon();
        }
        if (severity == Severity.WARNING) {
            return this.getWarningIcon();
        }
        return this.getInfoIcon();
    }

    private Icon getErrorIcon() {
        if (this.errorIcon == null) {
            this.errorIcon = UIManager.getIcon("OptionPane.errorIcon");
        }
        return this.errorIcon;
    }

    public void setErrorIcon(Icon icon) {
        this.errorIcon = icon;
    }

    private Icon getWarningIcon() {
        if (this.warningIcon == null) {
            this.warningIcon = UIManager.getIcon("OptionPane.warningIcon");
        }
        return this.warningIcon;
    }

    public void setWarningIcon(Icon icon) {
        this.warningIcon = icon;
    }

    private Icon getInfoIcon() {
        if (this.infoIcon == null) {
            this.infoIcon = UIManager.getIcon("OptionPane.informationIcon");
        }
        return this.infoIcon;
    }

    public void setInfoIcon(Icon icon) {
        this.infoIcon = icon;
    }
}

