/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.dialog;

import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.springframework.binding.form.FormModel;
import org.springframework.binding.form.ValidatingFormModel;
import org.springframework.core.closure.Closure;
import org.springframework.core.closure.Constraint;
import org.springframework.richclient.core.Message;
import org.springframework.richclient.dialog.ApplicationDialog;
import org.springframework.richclient.dialog.CloseAction;
import org.springframework.richclient.dialog.DefaultMessageAreaPane;
import org.springframework.richclient.dialog.Messagable;
import org.springframework.richclient.dialog.MessagePane;
import org.springframework.richclient.form.FormGuard;
import org.springframework.richclient.form.FormModelHelper;
import org.springframework.richclient.form.SimpleValidationResultsReporter;
import org.springframework.richclient.form.binding.swing.SwingBindingFactory;
import org.springframework.richclient.layout.TableLayoutBuilder;
import org.springframework.util.Assert;

public class InputApplicationDialog
extends ApplicationDialog
implements Messagable {
    private String inputLabelMessage = "dialog.input";
    private JComponent inputField;
    private Constraint inputConstraint;
    private Closure finishAction;
    private MessagePane reporter;
    private ValidatingFormModel formModel;

    public InputApplicationDialog(Object bean, String propertyName) {
        this(bean, propertyName, true);
    }

    public InputApplicationDialog(Object bean, String propertyName, boolean bufferChanges) {
        this(FormModelHelper.createFormModel(bean, bufferChanges), propertyName);
    }

    public InputApplicationDialog(ValidatingFormModel formModel, String propertyName) {
        this();
        this.formModel = formModel;
        this.setInputField(new SwingBindingFactory((FormModel)formModel).createBinding(propertyName).getControl());
    }

    public InputApplicationDialog() {
        this(null, null, CloseAction.DISPOSE);
    }

    public InputApplicationDialog(String title, Window parent) {
        this(title, parent, CloseAction.DISPOSE);
    }

    public InputApplicationDialog(String title, Window parent, CloseAction closeAction) {
        super(title, parent, closeAction);
        this.setResizable(true);
    }

    public void setInputField(JComponent field) {
        Assert.notNull((Object)field);
        this.inputField = field;
    }

    public void setInputLabelMessage(String inputLabel) {
        Assert.hasText((String)inputLabel, (String)"The input label is required");
        this.inputLabelMessage = inputLabel;
    }

    public void setInputConstraint(Constraint constraint) {
        this.inputConstraint = constraint;
    }

    public void setFinishAction(Closure procedure) {
        this.finishAction = procedure;
    }

    protected MessagePane createMessagePane() {
        return new DefaultMessageAreaPane();
    }

    private MessagePane getMessagePane() {
        if (this.reporter == null) {
            this.reporter = this.createMessagePane();
            if (this.formModel != null) {
                new SimpleValidationResultsReporter(this.formModel.getValidationResults(), this.reporter);
                FormGuard formGuard = new FormGuard(this.formModel);
                formGuard.addGuarded(this, 5);
            }
        }
        return this.reporter;
    }

    protected JComponent createDialogContentPane() {
        TableLayoutBuilder layoutBuilder = new TableLayoutBuilder();
        if (this.inputField == null) {
            this.inputField = this.getComponentFactory().createTextField();
        }
        if (this.inputField instanceof JFormattedTextField) {
            SelectAllBugFixer selectAllBugFixer = new SelectAllBugFixer();
            this.inputField.addFocusListener(selectAllBugFixer);
        }
        layoutBuilder.cell(this.createInputLabel(), "colGrId=label colSpec=left:pref");
        layoutBuilder.labelGapCol();
        layoutBuilder.cell(this.inputField);
        layoutBuilder.unrelatedGapRow();
        layoutBuilder.cell(this.getMessagePane().getControl());
        layoutBuilder.relatedGapRow();
        layoutBuilder.separator("");
        return layoutBuilder.getPanel();
    }

    protected JComponent createInputLabel() {
        return this.getComponentFactory().createLabelFor(this.inputLabelMessage, this.getInputField());
    }

    protected boolean onFinish() {
        if (this.checkInputConstraint()) {
            this.onFinish(this.getInputValue());
            return true;
        }
        return false;
    }

    private boolean checkInputConstraint() {
        if (this.inputConstraint != null) {
            return this.inputConstraint.test(this.getInputValue());
        }
        return true;
    }

    private Object getInputValue() {
        if (this.inputField instanceof JFormattedTextField) {
            return ((JFormattedTextField)this.inputField).getValue();
        }
        if (this.inputField instanceof JTextComponent) {
            return ((JTextComponent)this.inputField).getText();
        }
        throw new IllegalStateException("Input field type not supported");
    }

    protected void onFinish(Object inputValue) {
        if (this.formModel != null) {
            this.formModel.commit();
        }
        if (this.finishAction != null) {
            this.finishAction.call(inputValue);
        }
    }

    public ValidatingFormModel getFormModel() {
        return this.formModel;
    }

    public JComponent getInputField() {
        return this.inputField;
    }

    public void setMessage(Message message) {
        this.getMessagePane().setMessage(message);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getMessagePane().addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getMessagePane().addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getMessagePane().removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getMessagePane().removePropertyChangeListener(propertyName, listener);
    }

    private static class SelectAllBugFixer
    extends FocusAdapter {
        private SelectAllBugFixer() {
        }

        public void focusGained(final FocusEvent evt) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((JFormattedTextField)evt.getComponent()).selectAll();
                }
            });
        }
    }
}

