/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.dialog;

import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import org.springframework.richclient.core.DefaultMessage;
import org.springframework.richclient.core.Message;
import org.springframework.richclient.dialog.AlertMessageAreaPane;
import org.springframework.richclient.dialog.ApplicationDialog;
import org.springframework.util.Assert;

public class MessageDialog
extends ApplicationDialog {
    private static final String OK_FACE_DESCRIPTOR_ID = "okCommand";
    private AlertMessageAreaPane messageAreaPane;
    private Message message;
    private float dialogScaleFactor = 0.55f;
    private int minimumWidth = 600;

    public MessageDialog(String title, Message message) {
        this(title, null, message);
    }

    public MessageDialog(String title, Window parent, Message message) {
        super(title, parent);
        this.setMessage(message);
    }

    public MessageDialog(String title, String message) {
        this(title, null, message);
    }

    public MessageDialog(String title, Window parent, String message) {
        super(title, parent);
        this.setMessage(message);
    }

    public void setMessage(String text) {
        this.setMessage(new DefaultMessage(text));
    }

    public void setMessage(Message message) {
        Assert.notNull((Object)message, (String)"The message is required");
        Assert.hasText((String)message.getMessage(), (String)"The message text is required");
        this.message = message;
    }

    public Message getMessage() {
        return this.message;
    }

    protected String getCancelCommandId() {
        return OK_FACE_DESCRIPTOR_ID;
    }

    protected void registerDefaultCommand() {
        this.registerCancelCommandAsDefault();
    }

    protected Object[] getCommandGroupMembers() {
        return new Object[]{this.getCancelCommand()};
    }

    protected JComponent createDialogContentPane() {
        this.messageAreaPane = new AlertMessageAreaPane();
        this.messageAreaPane.setMessage(this.message);
        return this.messageAreaPane.getControl();
    }

    protected void disposeDialogContentPane() {
        this.messageAreaPane = null;
    }

    protected final boolean onFinish() {
        return true;
    }

    protected void onAboutToShow() {
        int width = this.getDialog().getWidth();
        float scale = this.getDialogScaleFactor();
        int parentWidth = this.getDialog().getParent().getWidth();
        if ((float)width > (float)parentWidth * scale) {
            int messageAreaPaneHeight = this.messageAreaPane.getPreferredHeight();
            width = (int)((float)parentWidth * scale);
            if (width < this.getMinimumWidth()) {
                width = this.getMinimumWidth();
            }
            this.getDialog().setSize(width, this.getDialog().getHeight());
            DialogSizeUpdater dialogSizeUpdater = new DialogSizeUpdater(messageAreaPaneHeight);
            this.getDialog().addComponentListener(dialogSizeUpdater);
        }
        this.getDialog().setResizable(false);
    }

    public float getDialogScaleFactor() {
        return this.dialogScaleFactor;
    }

    public void setDialogScaleFactor(float dialogScaleFactor) {
        this.dialogScaleFactor = dialogScaleFactor;
    }

    public int getMinimumWidth() {
        return this.minimumWidth;
    }

    public void setMinimumWidth(int minimumWidth) {
        this.minimumWidth = minimumWidth;
    }

    private class DialogSizeUpdater
    extends ComponentAdapter {
        private final int height;

        private DialogSizeUpdater(int height) {
            this.height = height;
        }

        public void componentShown(ComponentEvent e) {
            int newHeight = MessageDialog.this.getDialog().getHeight() + MessageDialog.this.messageAreaPane.getPreferredHeight() - this.height;
            MessageDialog.this.getDialog().setSize(MessageDialog.this.getDialog().getWidth(), newHeight);
        }
    }
}

