/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.springframework.richclient.core.DefaultMessage;
import org.springframework.richclient.core.DescriptionConfigurable;
import org.springframework.richclient.core.Message;
import org.springframework.richclient.dialog.ApplicationDialog;
import org.springframework.richclient.dialog.CloseAction;
import org.springframework.richclient.dialog.Messagable;
import org.springframework.richclient.dialog.TitlePane;
import org.springframework.richclient.image.config.ImageConfigurable;
import org.springframework.richclient.util.GuiStandardUtils;

public abstract class TitledApplicationDialog
extends ApplicationDialog
implements Messagable,
ImageConfigurable,
DescriptionConfigurable {
    private TitlePane titlePane = new TitlePane();
    private Message description = new DefaultMessage("Title pane description");
    private JComponent pageControl;
    private JComponent contentPane;

    public TitledApplicationDialog() {
    }

    public TitledApplicationDialog(String title, Window parent) {
        super(title, parent);
    }

    public TitledApplicationDialog(String title, Window parent, CloseAction closeAction) {
        super(title, parent, closeAction);
    }

    public void setCaption(String shortDescription) {
        throw new UnsupportedOperationException("What can I do with a caption?");
    }

    public void setDescription(String description) {
        this.description = new DefaultMessage(description);
        this.setMessage(this.description);
    }

    public void setTitlePaneTitle(String titleAreaText) {
        this.titlePane.setTitle(titleAreaText);
    }

    protected String getTitlePaneTitle() {
        return this.titlePane.getTitle();
    }

    public void setTitlePaneImage(Image image) {
        this.titlePane.setImage(image);
    }

    protected Image getTitlePaneImage() {
        return this.titlePane.getImage();
    }

    public void setImage(Image image) {
        this.setTitlePaneImage(image);
    }

    public Message getMessage() {
        return this.titlePane.getMessage();
    }

    public void setMessage(Message message) {
        if (message == null || DefaultMessage.EMPTY_MESSAGE.equals(message)) {
            this.titlePane.setMessage(this.getDescription());
        } else {
            this.titlePane.setMessage(message);
        }
    }

    public boolean isMessageShowing() {
        return this.titlePane.isMessageShowing();
    }

    protected Message getDescription() {
        return this.description;
    }

    protected void setContentPane(JComponent c) {
        if (!this.isControlCreated()) {
            throw new IllegalStateException("Cannot set content pane until control is created");
        }
        this.pageControl.remove(this.contentPane);
        this.contentPane = c;
        this.pageControl.add(this.contentPane);
        this.pageControl.revalidate();
        this.pageControl.repaint();
    }

    protected void addDialogComponents() {
        JComponent dialogContentPane = this.createDialogContentPane();
        this.getDialog().getContentPane().add((Component)dialogContentPane, "Center");
        this.getDialog().getContentPane().add((Component)this.createButtonBar(), "South");
    }

    protected JComponent createDialogContentPane() {
        this.pageControl = new JPanel(new BorderLayout());
        JPanel titlePaneContainer = new JPanel(new BorderLayout());
        this.setMessage(this.getDescription());
        titlePaneContainer.add(this.titlePane.getControl());
        titlePaneContainer.add((Component)new JSeparator(), "South");
        this.pageControl.add((Component)titlePaneContainer, "North");
        this.contentPane = this.createTitledDialogContentPane();
        if (this.getPreferredSize() != null) {
            this.contentPane.setPreferredSize(this.getPreferredSize());
        }
        GuiStandardUtils.attachDialogBorder(this.contentPane);
        this.pageControl.add(this.contentPane);
        return this.pageControl;
    }

    protected abstract JComponent createTitledDialogContentPane();

    protected void disposeDialogContentPane() {
        this.contentPane = null;
        this.pageControl = null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.titlePane.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.titlePane.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.titlePane.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.titlePane.removePropertyChangeListener(propertyName, listener);
    }
}

