/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.exceptionhandling;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.richclient.application.Application;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.application.ApplicationWindow;
import org.springframework.richclient.application.config.ApplicationLifecycleAdvisor;
import org.springframework.richclient.core.DefaultMessage;
import org.springframework.richclient.core.Severity;
import org.springframework.richclient.exceptionhandling.AwtExceptionHandlerAdapterHack;
import org.springframework.richclient.exceptionhandling.RegisterableExceptionHandler;
import org.springframework.util.StringUtils;

public class DefaultRegisterableExceptionHandler
implements RegisterableExceptionHandler {
    public void registerExceptionHandler() {
        AwtExceptionHandlerAdapterHack.registerExceptionHandler(this);
    }

    public void uncaughtException(Thread thread, Throwable throwable) {
        LogFactory.getLog((Class)ApplicationLifecycleAdvisor.class).error((Object)throwable.getMessage(), throwable);
        String exceptionMessage = throwable instanceof MessageSourceResolvable ? ((MessageSourceAccessor)ApplicationServicesLocator.services().getService(MessageSourceAccessor.class)).getMessage((MessageSourceResolvable)throwable) : throwable.getLocalizedMessage();
        if (!StringUtils.hasText((String)exceptionMessage)) {
            String defaultMessage = "An application exception occurred.\nPlease contact your administrator.";
            exceptionMessage = ((MessageSourceAccessor)ApplicationServicesLocator.services().getService(MessageSourceAccessor.class)).getMessage("applicationDialog.defaultException", defaultMessage);
        }
        DefaultMessage message = new DefaultMessage(exceptionMessage, Severity.ERROR);
        ApplicationWindow activeWindow = Application.instance().getActiveWindow();
        JFrame parentFrame = activeWindow == null ? null : activeWindow.getControl();
        JOptionPane.showMessageDialog(parentFrame, message.getMessage(), "Error", 0);
    }
}

