/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.filechooser;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.springframework.binding.form.FormModel;
import org.springframework.binding.form.ValidatingFormModel;
import org.springframework.binding.validation.ValidationListener;
import org.springframework.richclient.factory.AbstractControlFactory;
import org.springframework.richclient.form.binding.swing.SwingBindingFactory;

public class FileChooserComboBox
extends AbstractControlFactory {
    private JFileChooser fileChooser;
    private String fileChooserLabel = "fileChooserLabel";
    private JTextField fileNameField;
    private JButton browseButton;
    private File startDirectory;
    private ValidatingFormModel formModel;
    private String formProperty;

    public FileChooserComboBox() {
    }

    public FileChooserComboBox(ValidatingFormModel formModel, String formProperty) {
        this.formModel = formModel;
        this.formProperty = formProperty;
    }

    public void addValidationListener(ValidationListener listener) {
        this.formModel.getValidationResults().addValidationListener(listener);
    }

    public void removeValidationListener(ValidationListener listener) {
        this.formModel.getValidationResults().removeValidationListener(listener);
    }

    public void setLabelMessageCode(String labelKey) {
        this.fileChooserLabel = labelKey;
    }

    public void setStartDirectory(File file) {
        this.startDirectory = file;
    }

    public File getStartDirectory() {
        if (this.startDirectory != null) {
            return this.startDirectory;
        }
        return this.getSelectedFile();
    }

    public File getSelectedFile() {
        String filePath = (String)this.formModel.getValueModel(this.formProperty).getValue();
        return filePath == null ? null : new File(filePath);
    }

    public void setEnabled(boolean enabled) {
        this.fileNameField.setEnabled(enabled);
        this.browseButton.setEnabled(false);
    }

    protected JComponent createControl() {
        this.fileNameField = (JTextField)new SwingBindingFactory((FormModel)this.formModel).createBinding(JTextField.class, this.formProperty).getControl();
        JLabel fileToProcess = this.getComponentFactory().createLabelFor(this.fileChooserLabel, (JComponent)this.fileNameField);
        this.browseButton = this.getComponentFactory().createButton("button.browse");
        BrowseActionHandler browseActionHandler = new BrowseActionHandler();
        this.browseButton.addActionListener(browseActionHandler);
        FormLayout layout = new FormLayout("pref:grow, 6dlu:none, min", "pref, 3dlu, pref");
        JPanel panel = new JPanel((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        panel.add((Component)fileToProcess, cc.xyw(1, 1, 3));
        panel.add((Component)this.fileNameField, cc.xy(1, 3));
        panel.add((Component)this.browseButton, cc.xy(3, 3));
        return panel;
    }

    private class BrowseActionHandler
    implements ActionListener {
        private BrowseActionHandler() {
        }

        public void actionPerformed(ActionEvent event) {
            if (FileChooserComboBox.this.fileChooser == null) {
                FileChooserComboBox.this.fileChooser = new JFileChooser(FileChooserComboBox.this.getStartDirectory());
            } else {
                FileChooserComboBox.this.fileChooser.setCurrentDirectory(FileChooserComboBox.this.getStartDirectory());
            }
            int returnVal = FileChooserComboBox.this.fileChooser.showOpenDialog(SwingUtilities.getWindowAncestor(FileChooserComboBox.this.browseButton));
            if (returnVal == 0) {
                File selectedFile = FileChooserComboBox.this.fileChooser.getSelectedFile();
                FileChooserComboBox.this.fileNameField.setText(selectedFile.getAbsolutePath());
                if (selectedFile.isDirectory()) {
                    FileChooserComboBox.this.setStartDirectory(selectedFile);
                } else {
                    FileChooserComboBox.this.setStartDirectory(selectedFile.getParentFile());
                }
            }
        }
    }
}

