/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form;

import java.util.Date;
import javax.swing.JFormattedTextField;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.NumberFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.value.swing.ValueCommitPolicy;
import org.springframework.util.Assert;

public class FormatterFactory
extends JFormattedTextField.AbstractFormatterFactory {
    private static final Log logger = LogFactory.getLog((Class)FormatterFactory.class);
    private ValueCommitPolicy valueCommitPolicy = ValueCommitPolicy.AS_YOU_TYPE;
    private Class valueClass;

    public FormatterFactory(Class valueClass) {
        this(valueClass, ValueCommitPolicy.AS_YOU_TYPE);
    }

    public FormatterFactory(Class valueClass, ValueCommitPolicy policy) {
        this.valueClass = valueClass;
        this.setValueCommitPolicy(policy);
    }

    public void setValueCommitPolicy(ValueCommitPolicy policy) {
        Assert.notNull((Object)((Object)policy));
        this.valueCommitPolicy = policy;
    }

    public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField source) {
        Object value = source.getValue();
        DefaultFormatter formatter = value instanceof Date ? new DateFormatter() : (value instanceof Number ? new NumberFormatter() : new DefaultFormatter());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Factory returning new formatter " + formatter + " for text field " + source));
        }
        this.valueCommitPolicy.configure(source, formatter);
        if (this.valueClass != null) {
            formatter.setValueClass(this.valueClass);
        } else if (value != null) {
            formatter.setValueClass(value.getClass());
        }
        return formatter;
    }
}

