/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.springframework.binding.form.FormModel;
import org.springframework.core.enums.LabeledEnumResolver;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.form.binding.swing.AbstractListBinding;
import org.springframework.richclient.form.binding.swing.ComboBoxBinder;
import org.springframework.richclient.form.binding.swing.EnumComboBoxBinding;
import org.springframework.util.Assert;

public class EnumComboBoxBinder
extends ComboBoxBinder {
    private LabeledEnumResolver enumResolver;

    public EnumComboBoxBinder() {
        super(new String[]{"comparator", "renderer", "editor", "filter"});
    }

    protected AbstractListBinding createListBinding(JComponent control, FormModel formModel, String formPropertyPath) {
        Assert.isInstanceOf((Class)JComboBox.class, (Object)control, (String)formPropertyPath);
        return new EnumComboBoxBinding((JComboBox)control, formModel, formPropertyPath);
    }

    protected void applyContext(AbstractListBinding binding, Map context) {
        super.applyContext(binding, context);
        binding.setSelectableItems(this.createEnumSelectableItemsHolder(binding.getFormModel(), binding.getProperty()));
    }

    protected Collection createEnumSelectableItemsHolder(FormModel formModel, String formPropertyPath) {
        Set enumCollection = this.getLabeledEnumResolver().getLabeledEnumSet(this.getPropertyType(formModel, formPropertyPath));
        Assert.notNull((Object)enumCollection, (String)("Unable to resolve enums for class '" + this.getPropertyType(formModel, formPropertyPath).getName() + "'."));
        return enumCollection;
    }

    public LabeledEnumResolver getLabeledEnumResolver() {
        if (this.enumResolver == null) {
            this.enumResolver = (LabeledEnumResolver)ApplicationServicesLocator.services().getService(LabeledEnumResolver.class);
        }
        return this.enumResolver;
    }

    public void setEnumResolver(LabeledEnumResolver enumResolver) {
        this.enumResolver = enumResolver;
    }
}

