/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing;

import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.form.binding.swing.AbstractListBinder;
import org.springframework.richclient.form.binding.swing.AbstractListBinding;
import org.springframework.richclient.form.binding.swing.ListBinding;
import org.springframework.util.Assert;

public class ListBinder
extends AbstractListBinder {
    public static final String RENDERER_KEY = "renderer";
    public static final String SELECTION_MODE_KEY = "selectionMode";
    private ListCellRenderer renderer;
    private Integer selectionMode;

    public ListBinder() {
        this(null, new String[]{"selectableItems", "comparator", RENDERER_KEY, "filter", SELECTION_MODE_KEY});
    }

    public ListBinder(String[] supportedContextKeys) {
        this(null, supportedContextKeys);
    }

    public ListBinder(Class requiredSourceClass, String[] supportedContextKeys) {
        super(requiredSourceClass, supportedContextKeys);
    }

    protected AbstractListBinding createListBinding(JComponent control, FormModel formModel, String formPropertyPath) {
        Assert.isInstanceOf((Class)JList.class, (Object)control);
        return new ListBinding((JList)control, formModel, formPropertyPath, this.getRequiredSourceClass());
    }

    protected void applyContext(AbstractListBinding binding, Map context) {
        super.applyContext(binding, context);
        ListBinding listBinding = (ListBinding)binding;
        if (context.containsKey(RENDERER_KEY)) {
            listBinding.setRenderer((ListCellRenderer)this.decorate(context.get(RENDERER_KEY), listBinding.getRenderer()));
        } else if (this.renderer != null) {
            listBinding.setRenderer((ListCellRenderer)this.decorate(this.renderer, listBinding.getRenderer()));
        }
        if (context.containsKey(SELECTION_MODE_KEY)) {
            Object contextSelectionMode = context.get(SELECTION_MODE_KEY);
            if (contextSelectionMode instanceof Integer) {
                listBinding.setSelectionMode((Integer)contextSelectionMode);
            } else {
                try {
                    listBinding.setSelectionMode((Integer)ListSelectionModel.class.getField((String)contextSelectionMode).get(null));
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("Unable to access selection mode field in ListSelectionModel", e);
                }
                catch (NoSuchFieldException e) {
                    throw new IllegalArgumentException("Unknown selection mode '" + contextSelectionMode + "'", e);
                }
            }
        } else if (this.selectionMode != null) {
            listBinding.setSelectionMode(this.selectionMode);
        }
    }

    protected void applyContext(ListBinding binding, Map context) {
        if (context.containsKey(SELECTION_MODE_KEY)) {
            // empty if block
        }
    }

    protected JComponent createControl(Map context) {
        return this.getComponentFactory().createList();
    }

    public ListCellRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(ListCellRenderer renderer) {
        this.renderer = renderer;
    }

    public Integer getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(Integer selectionMode) {
        this.selectionMode = selectionMode;
    }
}

