/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing;

import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.form.binding.BinderSelectionStrategy;
import org.springframework.richclient.form.binding.Binding;
import org.springframework.richclient.form.binding.support.AbstractBinder;
import org.springframework.richclient.form.binding.swing.ScrollPaneDecoratedBinding;
import org.springframework.util.Assert;

public class ScrollPaneBinder
extends AbstractBinder {
    private final BinderSelectionStrategy viewBinderSelectionStrategy;
    private final Class defaultViewType;

    public ScrollPaneBinder(BinderSelectionStrategy viewBinderSelectionStrategy, Class defaultViewType) {
        super(null);
        this.viewBinderSelectionStrategy = viewBinderSelectionStrategy;
        this.defaultViewType = defaultViewType;
    }

    protected JComponent createControl(Map context) {
        return this.getComponentFactory().createScrollPane();
    }

    protected Binding doBind(JComponent control, FormModel formModel, String formPropertyPath, Map context) {
        Assert.isTrue((boolean)(control instanceof JScrollPane), (String)"Control must be an instance of JScrollPane.");
        JScrollPane scrollPane = (JScrollPane)control;
        Binding viewBinding = this.getViewBinding(scrollPane, formModel, formPropertyPath, context);
        return new ScrollPaneDecoratedBinding(viewBinding, scrollPane);
    }

    protected Binding getViewBinding(JScrollPane scrollPane, FormModel formModel, String formPropertyPath, Map context) {
        JComponent view = (JComponent)scrollPane.getViewport().getView();
        if (view == null) {
            Binding viewBinding = this.viewBinderSelectionStrategy.selectBinder(this.defaultViewType, formModel, formPropertyPath).bind(formModel, formPropertyPath, context);
            scrollPane.setViewportView(viewBinding.getControl());
            return viewBinding;
        }
        Binding existingBinding = (Binding)view.getClientProperty("binding");
        if (existingBinding != null) {
            return existingBinding;
        }
        return this.viewBinderSelectionStrategy.selectBinder(view.getClass(), formModel, formPropertyPath).bind(view, formModel, formPropertyPath, context);
    }

    protected void validateContextKeys(Map context) {
    }
}

