/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing;

import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.form.binding.Binding;
import org.springframework.richclient.form.binding.support.AbstractBinder;
import org.springframework.richclient.form.binding.swing.TextComponentBinding;
import org.springframework.util.Assert;

public class TextAreaBinder
extends AbstractBinder {
    public static final String ROWS_KEY = "rows";
    public static final String COLUMNS_KEY = "columns";

    public TextAreaBinder() {
        super(String.class, new String[]{ROWS_KEY, COLUMNS_KEY});
    }

    protected Binding doBind(JComponent control, FormModel formModel, String formPropertyPath, Map context) {
        Integer columns;
        Assert.isTrue((boolean)(control instanceof JTextArea), (String)"Control must be an instance of JTextArea.");
        JTextArea textArea = (JTextArea)control;
        Integer rows = (Integer)context.get(ROWS_KEY);
        if (rows != null) {
            textArea.setRows(rows);
        }
        if ((columns = (Integer)context.get(COLUMNS_KEY)) != null) {
            textArea.setColumns(columns);
        }
        return new TextComponentBinding((JTextArea)control, formModel, formPropertyPath);
    }

    protected JComponent createControl(Map context) {
        return this.getComponentFactory().createTextArea();
    }
}

