/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing.date;

import java.awt.Dimension;
import java.util.Map;
import javax.swing.JComponent;
import net.sf.nachocalendar.components.DateField;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.form.binding.Binding;
import org.springframework.richclient.form.binding.swing.date.AbstractDateFieldBinder;
import org.springframework.richclient.form.binding.swing.date.NachoCalendarDateFieldBinding;
import org.springframework.util.Assert;

public class NachoCalendarDateFieldBinder
extends AbstractDateFieldBinder {
    public static final String SHOW_OK_CANCEL_KEY = "showOkCancel";

    public NachoCalendarDateFieldBinder() {
        super(new String[]{SHOW_OK_CANCEL_KEY, "dateFormat"});
    }

    protected Binding doBind(JComponent control, FormModel formModel, String formPropertyPath, Map context) {
        Assert.isTrue((boolean)(control instanceof DateField), (String)"Control must be an instance of DateField.");
        NachoCalendarDateFieldBinding binding = new NachoCalendarDateFieldBinding((DateField)control, formModel, formPropertyPath);
        this.applyContext(binding, context);
        return binding;
    }

    protected void applyContext(NachoCalendarDateFieldBinding binding, Map context) {
        super.applyContext(binding, context);
        if (context.containsKey(SHOW_OK_CANCEL_KEY)) {
            binding.setShowOkCancel((Boolean)context.get(SHOW_OK_CANCEL_KEY));
        }
    }

    protected JComponent createControl(Map context) {
        final int preferredHeight = this.getComponentFactory().createComboBox().getPreferredSize().height;
        DateField dateField = new DateField(){

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.height = preferredHeight;
                return size;
            }
        };
        return dateField;
    }
}

