/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.builder;

import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.springframework.richclient.factory.ComponentFactory;
import org.springframework.richclient.form.binding.BindingFactory;
import org.springframework.richclient.form.builder.AbstractFormBuilder;
import org.springframework.richclient.layout.GridBagLayoutBuilder;
import org.springframework.richclient.layout.LabelOrientation;
import org.springframework.richclient.layout.LayoutBuilder;

public class GridBagLayoutFormBuilder
extends AbstractFormBuilder
implements LayoutBuilder {
    private final GridBagLayoutBuilder builder = new FormModelAwareGridBagLayoutBuilder();

    public GridBagLayoutFormBuilder(BindingFactory bindingFactory) {
        super(bindingFactory);
    }

    public final GridBagLayoutBuilder getBuilder() {
        return this.builder;
    }

    public void setComponentFactory(ComponentFactory componentFactory) {
        super.setComponentFactory(componentFactory);
        this.builder.setComponentFactory(componentFactory);
    }

    public GridBagLayoutFormBuilder appendLabeledField(String propertyName) {
        return this.appendLabeledField(propertyName, LabelOrientation.LEFT);
    }

    public GridBagLayoutFormBuilder appendLabeledField(String propertyName, int colSpan) {
        return this.appendLabeledField(propertyName, LabelOrientation.LEFT, colSpan);
    }

    public GridBagLayoutFormBuilder appendLabeledField(String propertyName, LabelOrientation labelOrientation) {
        return this.appendLabeledField(propertyName, labelOrientation, 1);
    }

    public GridBagLayoutFormBuilder appendLabeledField(String propertyName, LabelOrientation labelOrientation, int colSpan) {
        JComponent field = this.createDefaultBinding(propertyName).getControl();
        return this.appendLabeledField(propertyName, field, labelOrientation, colSpan);
    }

    public GridBagLayoutFormBuilder appendLabeledField(String propertyName, JComponent field, LabelOrientation labelOrientation) {
        return this.appendLabeledField(propertyName, field, labelOrientation, 1);
    }

    public GridBagLayoutFormBuilder appendLabeledField(String propertyName, JComponent field, LabelOrientation labelOrientation, int colSpan) {
        return this.appendLabeledField(propertyName, field, labelOrientation, colSpan, 1, true, false);
    }

    public GridBagLayoutFormBuilder appendLabeledField(String propertyName, JComponent field, LabelOrientation labelOrientation, int colSpan, int rowSpan, boolean expandX, boolean expandY) {
        this.builder.appendLabeledField(propertyName, field, labelOrientation, colSpan, rowSpan, expandX, expandY);
        return this;
    }

    public GridBagLayoutFormBuilder appendSeparator() {
        return this.appendSeparator(null);
    }

    public GridBagLayoutFormBuilder appendSeparator(String labelKey) {
        this.builder.appendSeparator(labelKey);
        return this;
    }

    public GridBagLayoutFormBuilder nextLine() {
        this.builder.nextLine();
        return this;
    }

    public void setShowGuidelines(boolean showGuidelines) {
        this.builder.setShowGuidelines(showGuidelines);
    }

    public JPanel getPanel() {
        return this.builder.getPanel();
    }

    public void setAutoSpanLastComponent(boolean autoSpanLastComponent) {
        this.builder.setAutoSpanLastComponent(autoSpanLastComponent);
    }

    protected final class FormModelAwareGridBagLayoutBuilder
    extends GridBagLayoutBuilder {
        protected FormModelAwareGridBagLayoutBuilder() {
        }

        protected JLabel createLabel(String propertyName) {
            JLabel label = this.getComponentFactory().createLabel("");
            GridBagLayoutFormBuilder.this.getFormModel().getFieldFace(propertyName).configure(label);
            return label;
        }
    }
}

