/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.builder.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.form.builder.FormComponentInterceptor;
import org.springframework.richclient.form.builder.FormComponentInterceptorFactory;
import org.springframework.util.Assert;

public class ChainedInterceptorFactory
implements FormComponentInterceptorFactory {
    public List interceptorFactories = Collections.EMPTY_LIST;

    public void setInterceptorFactories(List interceptorFactories) {
        Assert.notNull((Object)interceptorFactories);
        this.interceptorFactories = interceptorFactories;
    }

    public FormComponentInterceptor getInterceptor(FormModel formModel) {
        List interceptors = this.getInterceptors(formModel);
        if (interceptors.size() == 0) {
            return null;
        }
        return new ChainedInterceptor(interceptors);
    }

    private List getInterceptors(FormModel formModel) {
        ArrayList<FormComponentInterceptor> interceptors = new ArrayList<FormComponentInterceptor>();
        Iterator i = this.interceptorFactories.iterator();
        while (i.hasNext()) {
            FormComponentInterceptor interceptor = ((FormComponentInterceptorFactory)i.next()).getInterceptor(formModel);
            if (interceptor == null) continue;
            interceptors.add(interceptor);
        }
        return interceptors;
    }

    private static class ChainedInterceptor
    implements FormComponentInterceptor {
        private List interceptors;

        public ChainedInterceptor(List interceptors) {
            this.interceptors = interceptors;
        }

        public void processLabel(String propertyName, JComponent label) {
            Iterator i = this.interceptors.iterator();
            while (i.hasNext()) {
                FormComponentInterceptor interceptor = (FormComponentInterceptor)i.next();
                interceptor.processLabel(propertyName, label);
            }
        }

        public void processComponent(String propertyName, JComponent component) {
            Iterator i = this.interceptors.iterator();
            while (i.hasNext()) {
                FormComponentInterceptor interceptor = (FormComponentInterceptor)i.next();
                interceptor.processComponent(propertyName, component);
            }
        }
    }
}

