/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.builder.support;

import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.springframework.binding.form.FormModel;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.richclient.form.builder.support.AbstractFormComponentInterceptor;

public class CheckBoxFormComponentInterceptor
extends AbstractFormComponentInterceptor {
    private boolean showLabel = true;
    private boolean showText = false;
    private String textKey = "text";
    private MessageSource messageSource;

    public CheckBoxFormComponentInterceptor(FormModel formModel, MessageSource messageSource, boolean showLabel, boolean showText, String textKey) {
        super(formModel);
        this.messageSource = messageSource;
        this.showLabel = showLabel;
        this.showText = showText;
        this.textKey = textKey;
    }

    public void processComponent(String propertyName, JComponent component) {
        if (component instanceof JCheckBox && this.showText) {
            JCheckBox checkBox = (JCheckBox)component;
            checkBox.setText(this.fetchExtraText(this.messageSource, propertyName));
        }
    }

    protected String fetchExtraText(MessageSource messageSource, String propertyName) {
        return messageSource.getMessage((MessageSourceResolvable)new DefaultMessageSourceResolvable(this.getExtraTextKeys(propertyName), propertyName + "." + this.textKey), Locale.getDefault());
    }

    protected String[] getExtraTextKeys(String propertyName) {
        return new String[]{this.getFormModel().getId() + "." + propertyName + "." + this.textKey, propertyName + "." + this.textKey, this.textKey};
    }

    protected boolean isCheckBoxProperty(String propertyName) {
        Class type = this.getFormModel().getFieldMetadata(propertyName).getPropertyType();
        return Boolean.TYPE.equals(type) || Boolean.class.equals(type);
    }

    public void processLabel(String propertyName, JComponent label) {
        if (!this.showLabel && this.isCheckBoxProperty(propertyName)) {
            ((JLabel)label).setText("");
        }
    }
}

