/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.builder.support;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.core.Guarded;
import org.springframework.richclient.form.builder.FormComponentInterceptor;
import org.springframework.richclient.form.builder.FormComponentInterceptorFactory;
import org.springframework.richclient.form.builder.support.ValidationInterceptor;
import org.springframework.util.Assert;

public class ColorValidationInterceptorFactory
implements FormComponentInterceptorFactory {
    private static final Color DEFAULT_ERROR_COLOR = new Color(255, 240, 240);
    private Color errorColor = DEFAULT_ERROR_COLOR;

    public void setErrorColor(Color errorColor) {
        Assert.notNull((Object)errorColor);
        this.errorColor = errorColor;
    }

    public FormComponentInterceptor getInterceptor(FormModel formModel) {
        return new ColorValidationInterceptor(formModel);
    }

    static class ColorChanger
    implements Guarded {
        private Color normalColor;
        private JComponent component;
        private boolean changingColor;
        private Color errorColor;
        private boolean enabled;

        public ColorChanger(JComponent component, Color errorColor) {
            this.normalColor = component.getBackground();
            this.errorColor = errorColor;
            this.component = component;
            component.addPropertyChangeListener("background", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (ColorChanger.this.changingColor) {
                        return;
                    }
                    ColorChanger.this.normalColor = (Color)evt.getNewValue();
                    ColorChanger.this.setEnabled(ColorChanger.this.enabled);
                }
            });
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setEnabled(boolean enabled) {
            try {
                this.changingColor = true;
                this.enabled = enabled;
                this.component.setBackground(enabled ? this.normalColor : this.errorColor);
            }
            finally {
                this.changingColor = false;
            }
        }
    }

    private class ColorValidationInterceptor
    extends ValidationInterceptor {
        public ColorValidationInterceptor(FormModel formModel) {
            super(formModel);
        }

        public void processComponent(String propertyName, JComponent component) {
            JComponent innerComponent = this.getInnerComponent(component);
            if (innerComponent instanceof JTextComponent) {
                ColorChanger colorChanger = new ColorChanger(innerComponent, ColorValidationInterceptorFactory.this.errorColor);
                this.registerGuarded(propertyName, colorChanger);
            }
        }
    }
}

