/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.builder.support;

import javax.swing.JComponent;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.form.builder.FormComponentInterceptor;
import org.springframework.richclient.form.builder.FormComponentInterceptorFactory;
import org.springframework.richclient.form.builder.support.AbstractFormComponentInterceptor;

public class ToolTipInterceptorFactory
implements FormComponentInterceptorFactory {
    private boolean processComponent = true;
    private boolean processLabel = true;

    public FormComponentInterceptor getInterceptor(FormModel formModel) {
        return new ToolTipInterceptor(formModel);
    }

    public void setProcessComponent(boolean processComponent) {
        this.processComponent = processComponent;
    }

    public void setProcessLabel(boolean processLabel) {
        this.processLabel = processLabel;
    }

    private class ToolTipInterceptor
    extends AbstractFormComponentInterceptor {
        private FormModel formModel;

        public ToolTipInterceptor(FormModel formModel) {
            this.formModel = formModel;
        }

        String getCaption(String propertyName) {
            return this.formModel.getFieldFace(propertyName).getCaption();
        }

        public void processComponent(String propertyName, JComponent component) {
            if (ToolTipInterceptorFactory.this.processComponent) {
                component.setToolTipText(this.getCaption(propertyName));
            }
        }

        public void processLabel(String propertyName, JComponent label) {
            if (ToolTipInterceptorFactory.this.processLabel) {
                label.setToolTipText(this.getCaption(propertyName));
            }
        }
    }
}

