/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.list;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.springframework.util.Assert;

public class ComboBoxAutoCompletion
extends PlainDocument {
    private final ChangeHandler changeHandler = new ChangeHandler();
    private final JComboBox comboBox;
    private final JTextComponent editor;
    boolean hitBackspace;
    boolean hitBackspaceOnSelection;
    private Map item2string = new HashMap();
    private ComboBoxModel model;
    private boolean selectingValue;

    public ComboBoxAutoCompletion(JComboBox comboBox) {
        Assert.notNull((Object)comboBox, (String)"The ComboBox cannot be null.");
        Assert.isTrue((!comboBox.isEditable() ? 1 : 0) != 0, (String)"The ComboBox must not be editable.");
        Assert.isTrue((boolean)(comboBox.getEditor().getEditorComponent() instanceof JTextComponent), (String)"Only ComboBoxes with JTextComponent as editor are supported.");
        this.comboBox = comboBox;
        comboBox.setEditable(true);
        this.model = comboBox.getModel();
        this.model.addListDataListener(this.changeHandler);
        this.editor = (JTextComponent)comboBox.getEditor().getEditorComponent();
        this.editor.setDocument(this);
        this.editor.addFocusListener(this.changeHandler);
        this.editor.addKeyListener(this.changeHandler);
        this.fillItem2StringMap();
        Object selected = comboBox.getSelectedItem();
        comboBox.getEditor().setItem(selected);
    }

    private void fillItem2StringMap() {
        this.editor.setDocument(new PlainDocument());
        this.item2string.clear();
        JTextComponent editor = (JTextComponent)this.comboBox.getEditor().getEditorComponent();
        Object currentItem = this.comboBox.getEditor().getItem();
        for (int i = 0; i < this.comboBox.getItemCount(); ++i) {
            Object item = this.comboBox.getItemAt(i);
            this.comboBox.getEditor().setItem(item);
            this.item2string.put(item, editor.getText());
        }
        this.comboBox.getEditor().setItem(currentItem);
        editor.setDocument(this);
    }

    private String getStringFor(Object item) {
        return (String)this.item2string.get(item);
    }

    private void highlightCompletedText(int start) {
        this.editor.setCaretPosition(this.getLength());
        this.editor.moveCaretPosition(start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (str == null || str.length() == 0) {
            return;
        }
        if (this.selectingValue) {
            return;
        }
        if (offs < 0 || offs > this.getLength()) {
            throw new BadLocationException("Invalid offset - must be >= 0 and <= " + this.getLength(), offs);
        }
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String futureText = beforeOffset + str + afterOffset;
        Object item = this.lookupItem(futureText);
        if (item != null) {
            this.selectingValue = true;
            try {
                this.comboBox.setSelectedItem(item);
            }
            finally {
                this.selectingValue = false;
            }
        } else {
            item = this.comboBox.getSelectedItem();
            offs -= str.length();
            UIManager.getLookAndFeel().provideErrorFeedback(this.comboBox);
        }
        String itemString = item == null ? "" : this.getStringFor(item);
        this.setText(itemString);
        if (itemString != null) {
            if (itemString.equals(str) && offs == 0) {
                this.highlightCompletedText(0);
            } else {
                this.highlightCompletedText(offs + str.length());
                if (this.comboBox.isShowing()) {
                    this.comboBox.setPopupVisible(true);
                }
            }
        }
    }

    private Object lookupItem(String pattern) {
        Object selectedItem = this.model.getSelectedItem();
        if (selectedItem != null && this.startsWithIgnoreCase(this.getStringFor(selectedItem), pattern)) {
            return selectedItem;
        }
        int n = this.model.getSize();
        for (int i = 0; i < n; ++i) {
            Object currentItem = this.model.getElementAt(i);
            if (!this.startsWithIgnoreCase(this.getStringFor(currentItem), pattern)) continue;
            return currentItem;
        }
        return null;
    }

    public void remove(int offs, int length) throws BadLocationException {
        if (length == 0) {
            return;
        }
        if (offs < 0 || offs > this.getLength() || length < 0 || offs + length > this.getLength()) {
            throw new BadLocationException("Invalid parameters.", offs);
        }
        if (this.hitBackspace) {
            if (offs > 0) {
                if (this.hitBackspaceOnSelection) {
                    --offs;
                }
            } else {
                this.comboBox.getToolkit().beep();
            }
            this.highlightCompletedText(offs);
            if (this.comboBox.isShowing()) {
                this.comboBox.setPopupVisible(true);
            }
        } else {
            super.remove(offs, length);
        }
    }

    private void setText(String text) throws BadLocationException {
        super.remove(0, this.getLength());
        super.insertString(0, text, null);
    }

    private boolean startsWithIgnoreCase(String str1, String str2) {
        return str1 != null && str2 != null && str1.toUpperCase().startsWith(str2.toUpperCase());
    }

    private final class ChangeHandler
    extends KeyAdapter
    implements FocusListener,
    ListDataListener {
        private boolean hidePopupOnFocusLoss = System.getProperty("java.version").startsWith("1.5");

        private ChangeHandler() {
        }

        public void keyPressed(KeyEvent e) {
            ComboBoxAutoCompletion.this.hitBackspace = false;
            switch (e.getKeyCode()) {
                case 10: {
                    ComboBoxAutoCompletion.this.highlightCompletedText(0);
                    break;
                }
                case 8: {
                    ComboBoxAutoCompletion.this.hitBackspace = true;
                    ComboBoxAutoCompletion.this.hitBackspaceOnSelection = ComboBoxAutoCompletion.this.editor.getSelectionStart() != ComboBoxAutoCompletion.this.editor.getSelectionEnd();
                    break;
                }
                case 127: {
                    e.consume();
                    ComboBoxAutoCompletion.this.comboBox.getToolkit().beep();
                }
            }
        }

        public void focusGained(FocusEvent e) {
            ComboBoxAutoCompletion.this.highlightCompletedText(0);
        }

        public void focusLost(FocusEvent e) {
            if (this.hidePopupOnFocusLoss) {
                ComboBoxAutoCompletion.this.comboBox.setPopupVisible(false);
            }
        }

        public void contentsChanged(ListDataEvent e) {
            if (!ComboBoxAutoCompletion.this.selectingValue) {
                ComboBoxAutoCompletion.this.fillItem2StringMap();
            }
        }

        public void intervalAdded(ListDataEvent e) {
            ComboBoxAutoCompletion.this.fillItem2StringMap();
        }

        public void intervalRemoved(ListDataEvent e) {
            ComboBoxAutoCompletion.this.fillItem2StringMap();
        }
    }
}

