/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.MutableComboBoxModel;
import org.springframework.binding.value.support.ListListModel;
import org.springframework.util.ObjectUtils;

public class ComboBoxListModel
extends ListListModel
implements ComboBoxModel,
MutableComboBoxModel {
    private Object selectedItem;

    public ComboBoxListModel() {
        this(new ArrayList(9));
    }

    public ComboBoxListModel(List items) {
        super(items);
        if (this.getSize() > 0) {
            this.selectedItem = this.getElementAt(0);
        }
    }

    public ComboBoxListModel(List items, Comparator sorter) {
        super(items, sorter);
        if (this.getSize() > 0) {
            this.selectedItem = this.getElementAt(0);
        }
    }

    public Object getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(Object anItem) {
        if (!ObjectUtils.nullSafeEquals((Object)this.selectedItem, (Object)anItem)) {
            this.selectedItem = anItem;
            if (this.selectedItem == null) {
                this.setSelectedItemOnNullValue();
            }
            this.fireContentsChanged(this, -1, -1);
        }
    }

    public void add(int index, Object o) {
        super.add(index, o);
        this.setSelectedItemIfNecessary(o);
    }

    protected void setSelectedItemOnNullValue() {
        this.setSelectedItemIfNecessary(null);
    }

    protected void setSelectedItemIfNecessary(Object o) {
        if (this.getItems().size() > 0 && this.getSelectedItem() == null) {
            if (o != null) {
                this.setSelectedItem(o);
            } else {
                this.setSelectedItem(this.getItems().get(0));
            }
        }
    }

    public boolean add(Object o) {
        boolean result = super.add(o);
        if (result) {
            this.setSelectedItemIfNecessary(o);
        }
        return result;
    }

    public boolean addAll(Collection c) {
        boolean result = super.addAll(c);
        if (result) {
            this.setSelectedItemIfNecessary(null);
        }
        return result;
    }

    public boolean addAll(int index, Collection c) {
        boolean result = super.addAll(index, c);
        if (result) {
            this.setSelectedItemIfNecessary(null);
        }
        return result;
    }

    public void clear() {
        super.clear();
        this.selectedItem = null;
    }

    public Object remove(int index) {
        if (this.get(index) == this.selectedItem) {
            if (index == 0) {
                this.setSelectedItem(this.getSize() == 1 ? null : this.get(index + 1));
            } else {
                this.setSelectedItem(this.get(index - 1));
            }
        }
        return super.remove(index);
    }

    public void addElement(Object anObject) {
        this.add(anObject);
    }

    public void insertElementAt(Object anObject, int index) {
        this.add(index, anObject);
    }

    public void removeElementAt(int index) {
        this.remove(index);
    }

    public void removeElement(Object o) {
        this.remove(o);
    }
}

