/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.list;

import javax.swing.ComboBoxModel;
import javax.swing.ListModel;
import org.springframework.core.closure.Constraint;
import org.springframework.richclient.list.FilteredListModel;
import org.springframework.util.Assert;

public class FilteredComboBoxListModel
extends FilteredListModel
implements ComboBoxModel {
    private boolean matchedSelected;
    private boolean selectingItem;

    public FilteredComboBoxListModel(ComboBoxModel filteredModel, Constraint filter) {
        super(filteredModel, filter);
    }

    public void setFilteredModel(ListModel model) {
        Assert.isInstanceOf((Class)ComboBoxModel.class, (Object)model);
        super.setFilteredModel(model);
    }

    protected ComboBoxModel getComboBoxModel() {
        return (ComboBoxModel)this.getFilteredModel();
    }

    protected void onMatchingElement(Object element) {
        if (element == this.getSelectedItem()) {
            this.matchedSelected = true;
        }
    }

    protected void postConstraintApplied() {
        if (!this.matchedSelected) {
            if (this.getSize() > 0) {
                this.setSelectedItem(this.getElementAt(0));
            } else {
                this.setSelectedItem(null);
            }
        }
        this.matchedSelected = false;
    }

    public Object getSelectedItem() {
        if (this.getSize() == 0) {
            return null;
        }
        return this.getComboBoxModel().getSelectedItem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedItem(Object anItem) {
        if (!this.selectingItem) {
            this.selectingItem = true;
            try {
                this.getComboBoxModel().setSelectedItem(anItem);
            }
            finally {
                this.selectingItem = false;
            }
        }
    }
}

