/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.list;

import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.springframework.binding.value.support.AbstractValueModel;

public class ListSelectionValueModelAdapter
extends AbstractValueModel
implements ListSelectionListener {
    private ListSelectionModel model;
    private int[] currentSelection = new int[0];
    private boolean skipSelectionModelUpdate = false;

    public ListSelectionValueModelAdapter(ListSelectionModel model) {
        this.model = model;
        this.model.addListSelectionListener(this);
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.skipSelectionModelUpdate = true;
            this.setValue(this.getSelectedRows());
            this.skipSelectionModelUpdate = false;
        }
    }

    public Object getValue() {
        return this.currentSelection;
    }

    public void setValue(Object newValue) {
        int[] newSelection = (int[])newValue;
        if (this.hasChanged(this.currentSelection, newSelection)) {
            int[] oldValue = this.currentSelection;
            this.currentSelection = newSelection;
            this.fireValueChange(oldValue, this.currentSelection);
            if (!this.skipSelectionModelUpdate) {
                this.model.removeListSelectionListener(this);
                this.model.clearSelection();
                int len = newSelection.length;
                for (int i = 0; i < len; ++i) {
                    int start = newSelection[i];
                    while (i < len - 1 && newSelection[i] == newSelection[i + 1] - 1) {
                        ++i;
                    }
                    int end = newSelection[i];
                    this.model.addSelectionInterval(start, end);
                }
                this.model.addListSelectionListener(this);
            }
        }
    }

    private boolean hasChanged(int[] oldValue, int[] newValue) {
        if (oldValue.length == newValue.length) {
            for (int i = 0; i < newValue.length; ++i) {
                if (oldValue[i] == newValue[i]) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private int[] getSelectedRows() {
        int iMin = this.model.getMinSelectionIndex();
        int iMax = this.model.getMaxSelectionIndex();
        if (iMin == -1 || iMax == -1) {
            return new int[0];
        }
        int[] rvTmp = new int[1 + (iMax - iMin)];
        int n = 0;
        for (int i = iMin; i <= iMax; ++i) {
            if (!this.model.isSelectedIndex(i)) continue;
            rvTmp[n++] = i;
        }
        int[] rv = new int[n];
        System.arraycopy(rvTmp, 0, rv, 0, n);
        return rv;
    }
}

