/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.list;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.comparators.TransformingComparator;
import org.springframework.richclient.list.AbstractFilteredListModel;
import org.springframework.util.Assert;
import org.springframework.util.comparator.ComparableComparator;

public class SortedListModel
extends AbstractFilteredListModel {
    private static Comparator comparableComparator = new ComparableComparator();
    private Comparator comparator;
    private Integer[] indexes;
    private final Observer comparatorObserver = new ComparatorObserver();

    public SortedListModel(ListModel model) {
        this(model, comparableComparator);
    }

    public SortedListModel(ListModel model, Comparator comparator) {
        super(model);
        Assert.notNull((Object)comparator);
        this.comparator = comparator;
        if (comparator instanceof Observable) {
            ((Observable)((Object)comparator)).addObserver(this.comparatorObserver);
        }
        this.reallocateIndexes();
    }

    public void setComparator(Comparator comparator) {
        Assert.notNull((Object)comparator);
        if (this.comparator instanceof Observable) {
            ((Observable)((Object)comparator)).deleteObserver(this.comparatorObserver);
        }
        this.comparator = comparator;
        if (this.comparator instanceof Observable) {
            ((Observable)((Object)comparator)).addObserver(this.comparatorObserver);
        }
        this.applyComparator();
    }

    protected void reallocateIndexes() {
        this.indexes = new Integer[this.getFilteredModel().getSize()];
        for (int i = 0; i < this.indexes.length; ++i) {
            this.indexes[i] = new Integer(i);
        }
        this.applyComparator();
    }

    public int getElementIndex(int sortedIndex) {
        return this.indexes[sortedIndex];
    }

    protected void applyComparator() {
        Integer[] indexes = new Integer[this.indexes.length];
        System.arraycopy(this.indexes, 0, indexes, 0, indexes.length);
        Arrays.sort(indexes, new TransformingComparator((Transformer)new IndexToElementTransformer(this.getFilteredModel()), this.comparator));
        this.indexes = indexes;
        this.fireContentsChanged(this, -1, -1);
    }

    public void contentsChanged(ListDataEvent e) {
        this.reallocateIndexes();
    }

    public void intervalAdded(ListDataEvent e) {
        this.reallocateIndexes();
    }

    public void intervalRemoved(ListDataEvent e) {
        this.reallocateIndexes();
    }

    private class ComparatorObserver
    implements Observer {
        private ComparatorObserver() {
        }

        public void update(Observable o, Object arg) {
            SortedListModel.this.applyComparator();
        }
    }

    private static class IndexToElementTransformer
    implements Transformer {
        private final ListModel model;

        public IndexToElementTransformer(ListModel model) {
            this.model = model;
        }

        public Object transform(Object input) {
            return this.model.getElementAt((Integer)input);
        }
    }
}

