/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.progress;

import javax.swing.tree.TreePath;
import org.springframework.richclient.application.statusbar.StatusBar;
import org.springframework.richclient.tree.TreeSelectionListenerSupport;
import org.springframework.util.Assert;

public abstract class TreeStatusBarUpdater
extends TreeSelectionListenerSupport {
    private StatusBar statusBar;

    public TreeStatusBarUpdater(StatusBar statusBar) {
        Assert.notNull((Object)statusBar);
        this.statusBar = statusBar;
    }

    private StatusBar getStatusBar() {
        return this.statusBar;
    }

    protected void onSingleSelection(TreePath newPath) {
        this.updateStatusBar(this.getSelectedObjectName());
    }

    protected abstract String getSelectedObjectName();

    protected void onMultiSelection(TreePath[] newPaths) {
        this.updateStatusBar(this.getItemsSelected());
    }

    protected void onNoSelection() {
        this.updateStatusBar(null);
    }

    private void updateStatusBar(int itemsSelected) {
        this.getStatusBar().setMessage(itemsSelected + " items selected");
    }

    private void updateStatusBar(String selectedObjectName) {
        if (selectedObjectName != null) {
            this.getStatusBar().setMessage(selectedObjectName);
        } else {
            this.getStatusBar().setMessage((String)null);
        }
    }
}

