/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.security;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.acegisecurity.Authentication;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.richclient.security.AuthenticationAware;
import org.springframework.richclient.security.AuthenticationEvent;
import org.springframework.richclient.security.ClientSecurityEvent;
import org.springframework.richclient.security.LoginAware;
import org.springframework.richclient.security.LoginEvent;
import org.springframework.richclient.security.LogoutEvent;

public class SecurityAwareConfigurer
implements ApplicationListener,
ApplicationContextAware,
BeanPostProcessor {
    private final Log logger = LogFactory.getLog(this.getClass());
    private ApplicationContext applicationContext;
    private final List nonSingletonListeners = Collections.synchronizedList(new ArrayList());
    private Authentication currentAuthentication = null;

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    protected void broadcastAuthentication(Authentication authentication) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("BROADCAST authentication: token=" + authentication));
        }
        this.currentAuthentication = authentication;
        Iterator iter = this.getBeansToUpdate(AuthenticationAware.class).iterator();
        while (iter.hasNext()) {
            ((AuthenticationAware)iter.next()).setAuthenticationToken(authentication);
        }
    }

    protected void broadcastLogin(Authentication authentication) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("BROADCAST login: token=" + authentication));
        }
        Iterator iter = this.getBeansToUpdate(LoginAware.class).iterator();
        while (iter.hasNext()) {
            ((LoginAware)iter.next()).userLogin(authentication);
        }
    }

    protected void broadcastLogout(Authentication authentication) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("BROADCAST logout: token=" + authentication));
        }
        Iterator iter = this.getBeansToUpdate(LoginAware.class).iterator();
        while (iter.hasNext()) {
            ((LoginAware)iter.next()).userLogout(authentication);
        }
    }

    protected List getBeansToUpdate(Class beanType) {
        ApplicationContext ac = this.getApplicationContext();
        ArrayList listeners = new ArrayList();
        if (ac != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Constructing list of beans to notify; bean type=" + beanType.getName()));
            }
            Map map = ac.getBeansOfType(beanType, false, true);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("bean map: " + map));
            }
            listeners.addAll(map.values());
            listeners.addAll(this.getNonSingletonListeners(beanType));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("List of beans to notify:" + listeners));
        }
        return listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getNonSingletonListeners(Class beanType) {
        ArrayList listeners = new ArrayList();
        List list = this.nonSingletonListeners;
        synchronized (list) {
            Iterator iter = this.nonSingletonListeners.iterator();
            while (iter.hasNext()) {
                Object bean = ((WeakReference)iter.next()).get();
                if (bean == null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"REMOVED garbage collected AuthorizationAware non-singleton from list.");
                    }
                    iter.remove();
                    continue;
                }
                if (!beanType.isAssignableFrom(bean.getClass())) continue;
                listeners.add(bean);
            }
        }
        return listeners;
    }

    protected void addToNonSingletonListeners(Object bean) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding Authentication/LoginAware bean to list of non-singleton listeners: bean='" + bean));
        }
        this.nonSingletonListeners.add(new WeakReference<Object>(bean));
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ClientSecurityEvent) {
            Authentication authentication = (Authentication)event.getSource();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("RECEIVED ClientSecurityEvent: " + event));
                this.logger.debug((Object)("Authentication token: " + authentication));
            }
            if (authentication == ClientSecurityEvent.NO_AUTHENTICATION) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Converted NO_AUTHENTICATION to null");
                }
                authentication = null;
            }
            if (event instanceof AuthenticationEvent) {
                this.broadcastAuthentication(authentication);
            } else if (event instanceof LoginEvent) {
                this.broadcastLogin(authentication);
            } else if (event instanceof LogoutEvent) {
                this.broadcastLogout(authentication);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Unsupported event not processed");
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof AuthenticationAware || bean instanceof LoginAware) {
            if (beanName == null || !this.getApplicationContext().containsBean(beanName) || !this.getApplicationContext().isSingleton(beanName)) {
                this.addToNonSingletonListeners(bean);
            }
            if (bean instanceof AuthenticationAware) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("NOTIFY bean '" + bean + "' of new authorization for '" + this.currentAuthentication + "'"));
                }
                AuthenticationAware aab = (AuthenticationAware)bean;
                aab.setAuthenticationToken(this.currentAuthentication);
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

