/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.security.remoting;

import org.acegisecurity.Authentication;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.springframework.remoting.httpinvoker.CommonsHttpInvokerRequestExecutor;
import org.springframework.remoting.httpinvoker.HttpInvokerProxyFactoryBean;
import org.springframework.remoting.httpinvoker.HttpInvokerRequestExecutor;
import org.springframework.richclient.security.AuthenticationAware;

public class BasicAuthCommonsHttpInvokerProxyFactoryBean
extends HttpInvokerProxyFactoryBean
implements AuthenticationAware {
    public BasicAuthCommonsHttpInvokerProxyFactoryBean() {
        this.setHttpInvokerRequestExecutor((HttpInvokerRequestExecutor)new CommonsHttpInvokerRequestExecutor());
    }

    public void setAuthenticationToken(Authentication authentication) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("New authentication token: " + authentication));
        }
        CommonsHttpInvokerRequestExecutor executor = (CommonsHttpInvokerRequestExecutor)this.getHttpInvokerRequestExecutor();
        HttpClient httpClient = executor.getHttpClient();
        httpClient.getParams().setAuthenticationPreemptive(authentication != null);
        UsernamePasswordCredentials usernamePasswordCredentials = authentication != null ? new UsernamePasswordCredentials(authentication.getName(), authentication.getCredentials().toString()) : null;
        httpClient.getState().setCredentials(AuthScope.ANY, usernamePasswordCredentials);
    }
}

