/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.security.remoting;

import java.io.IOException;
import java.net.HttpURLConnection;
import org.acegisecurity.Authentication;
import org.apache.commons.codec.binary.Base64;
import org.springframework.remoting.httpinvoker.SimpleHttpInvokerRequestExecutor;
import org.springframework.richclient.security.AuthenticationAware;

public class BasicAuthHttpInvokerRequestExecutor
extends SimpleHttpInvokerRequestExecutor
implements AuthenticationAware {
    private Authentication authentication;

    public void setAuthenticationToken(Authentication authentication) {
        this.authentication = authentication;
    }

    public Authentication getAuthenticationToken() {
        return this.authentication;
    }

    protected void doPrepareConnection(HttpURLConnection con, int contentLength) throws IOException {
    }

    protected void prepareConnection(HttpURLConnection con, int contentLength) throws IOException {
        super.prepareConnection(con, contentLength);
        Authentication auth = this.getAuthenticationToken();
        if (auth != null && auth.getName() != null && auth.getCredentials() != null) {
            String base64 = auth.getName() + ":" + auth.getCredentials().toString();
            con.setRequestProperty("Authorization", "Basic " + new String(Base64.encodeBase64((byte[])base64.getBytes())));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("HttpInvocation now presenting via BASIC authentication with token:: " + auth));
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Unable to set BASIC authentication header as Authentication token is invalid: " + auth));
        }
        this.doPrepareConnection(con, contentLength);
    }
}

