/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.table;

import java.util.List;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.richclient.table.BaseTableModel;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class BeanTableModel
extends BaseTableModel {
    private BeanWrapper beanWrapper = new BeanWrapperImpl();
    private Class beanClass;
    private String[] columnPropertyNames;
    private MessageSourceAccessor messages;

    public BeanTableModel(Class beanClass) {
        this(beanClass, (MessageSource)null);
    }

    public BeanTableModel(Class beanClass, List rows) {
        this(beanClass, rows, null);
    }

    public BeanTableModel(Class beanClass, MessageSource messages) {
        this.setBeanClass(beanClass);
        this.setMessageSource(messages);
    }

    public BeanTableModel(Class beanClass, List rows, MessageSource messages) {
        super(rows);
        this.setBeanClass(beanClass);
        this.setMessageSource(messages);
    }

    public void setBeanClass(Class clazz) {
        this.beanClass = clazz;
    }

    public void setMessageSource(MessageSource messages) {
        if (messages != null) {
            this.messages = new MessageSourceAccessor(messages);
            this.createColumnInfo();
        } else {
            this.messages = null;
        }
    }

    protected void createColumnInfo() {
        this.columnPropertyNames = this.createColumnPropertyNames();
        super.createColumnInfo();
    }

    protected abstract String[] createColumnPropertyNames();

    protected String[] createColumnNames() {
        String[] columnPropertyNames = this.getColumnPropertyNames();
        String[] columnNames = new String[columnPropertyNames.length];
        Assert.state((this.messages != null ? 1 : 0) != 0, (String)"First set the MessageSource.");
        for (int i = 0; i < columnPropertyNames.length; ++i) {
            String className = ClassUtils.getShortNameAsProperty((Class)this.beanClass);
            String columnPropertyName = columnPropertyNames[i];
            try {
                columnNames[i] = this.messages.getMessage(className + "." + columnPropertyName);
                continue;
            }
            catch (NoSuchMessageException e) {
                columnNames[i] = this.messages.getMessage(columnPropertyName, columnPropertyName);
            }
        }
        return columnNames;
    }

    protected String[] getColumnPropertyNames() {
        return this.columnPropertyNames;
    }

    private String getColumnPropertyName(int index) {
        return this.columnPropertyNames[index];
    }

    protected Object getValueAtInternal(Object row, int columnIndex) {
        this.beanWrapper.setWrappedInstance(row);
        return this.beanWrapper.getPropertyValue(this.columnPropertyNames[columnIndex]);
    }

    protected boolean isCellEditableInternal(Object row, int columnIndex) {
        this.beanWrapper.setWrappedInstance(row);
        return this.beanWrapper.isWritableProperty(this.getColumnPropertyName(columnIndex));
    }

    protected void setValueAtInternal(Object value, Object bean, int columnIndex) {
        this.beanWrapper.setWrappedInstance(bean);
        this.beanWrapper.setPropertyValue(this.getColumnPropertyName(columnIndex), value);
    }
}

