/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.table;

import java.util.ArrayList;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.springframework.util.Assert;

public class ListSelectionListenerSupport
implements ListSelectionListener {
    private int itemsSelected = 0;

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = this.getListSelectionModel(e);
        if (listSelectionModel.isSelectionEmpty()) {
            this.itemsSelected = 0;
            this.onNoSelection();
        } else {
            ArrayList<Integer> indexList = new ArrayList<Integer>();
            int minIndex = listSelectionModel.getMinSelectionIndex();
            int maxIndex = listSelectionModel.getMaxSelectionIndex();
            for (int i = minIndex; i <= maxIndex; ++i) {
                if (!listSelectionModel.isSelectedIndex(i)) continue;
                indexList.add(new Integer(i));
            }
            this.itemsSelected = indexList.size();
            if (this.itemsSelected == 1) {
                this.onSingleSelection((Integer)indexList.get(0));
            } else {
                int[] indexes = new int[indexList.size()];
                for (int i = 0; i < indexList.size(); ++i) {
                    indexes[i] = (Integer)indexList.get(i);
                }
                this.onMultiSelection(indexes);
            }
        }
    }

    private ListSelectionModel getListSelectionModel(ListSelectionEvent e) {
        if (e.getSource() instanceof JList) {
            return ((JList)e.getSource()).getSelectionModel();
        }
        Assert.isTrue((boolean)(e.getSource() instanceof ListSelectionModel), (String)"Unsupported source in ListSelectionEvent");
        return (ListSelectionModel)e.getSource();
    }

    protected int getItemsSelected() {
        return this.itemsSelected;
    }

    protected void onMultiSelection(int[] indexes) {
    }

    protected void onNoSelection() {
    }

    protected void onSingleSelection(int index) {
    }
}

