/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.table;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;
import org.springframework.core.style.StylerUtils;
import org.springframework.richclient.table.AbstractTableModelFilter;
import org.springframework.richclient.table.ColumnToSort;
import org.springframework.richclient.table.SortOrder;
import org.springframework.richclient.table.SortableTableModel;
import org.springframework.richclient.table.ToStringComparator;
import org.springframework.util.Assert;
import org.springframework.util.comparator.NullSafeComparator;

public class ShuttleSortableTableModel
extends AbstractTableModelFilter
implements SortableTableModel {
    private static final Comparator OBJECT_COMPARATOR = new NullSafeComparator((Comparator)ToStringComparator.INSTANCE, true);
    private static final Comparator COMPARABLE_COMPARATOR = NullSafeComparator.NULLS_LOW;
    private Comparator[] columnComparators;
    private List columnsToSort = new ArrayList(4);
    private int[] indexes;
    private int compares;
    private boolean autoSortEnabled = true;
    private Runnable notifyTableRunnable = new Runnable(){

        public void run() {
            ShuttleSortableTableModel.this.fireTableDataChanged();
        }
    };
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Comparable;

    public ShuttleSortableTableModel(TableModel model) {
        super(model);
        this.allocateIndexes();
        this.resetComparators();
    }

    private void allocateIndexes() {
        int rowCount = this.filteredModel.getRowCount();
        this.indexes = new int[rowCount];
        for (int row = 0; row < rowCount; ++row) {
            this.indexes[row] = row;
        }
    }

    public void resetComparators() {
        this.resetComparators(Collections.EMPTY_MAP);
    }

    public void resetComparators(Map comparators) {
        int colCount = this.filteredModel.getColumnCount();
        this.columnComparators = new Comparator[colCount];
        for (int i = 0; i < this.columnComparators.length; ++i) {
            Comparator newComparator = (Comparator)comparators.get(i);
            if (newComparator != null) {
                this.setComparator(i, newComparator);
                continue;
            }
            Class<?> clazz = this.filteredModel.getColumnClass(i);
            if (clazz != (class$java$lang$Object == null ? ShuttleSortableTableModel.class$("java.lang.Object") : class$java$lang$Object) && (class$java$lang$Comparable == null ? ShuttleSortableTableModel.class$("java.lang.Comparable") : class$java$lang$Comparable).isAssignableFrom(clazz)) continue;
            this.columnComparators[i] = OBJECT_COMPARATOR;
        }
    }

    public boolean isCellEditable(int row, int column) {
        return this.filteredModel.isCellEditable(this.indexes[row], column);
    }

    public boolean isAutoSortEnabled() {
        return this.autoSortEnabled;
    }

    public void setAutoSortEnabled(boolean autoSortEnabled) {
        this.autoSortEnabled = autoSortEnabled;
    }

    public Comparator getComparator(int columnIndex) {
        return this.columnComparators[columnIndex];
    }

    public void setComparator(int columnIndex, Comparator comparator) {
        Assert.notNull((Object)comparator);
        this.columnComparators[columnIndex] = comparator;
    }

    public Object getValueAt(int row, int column) {
        return this.filteredModel.getValueAt(this.indexes[row], column);
    }

    public void setValueAt(Object value, int row, int column) {
        this.filteredModel.setValueAt(value, this.indexes[row], column);
    }

    public void sortByColumn(ColumnToSort columnToSort) {
        this.columnsToSort.clear();
        this.columnsToSort.add(columnToSort);
        this.sort();
        SwingUtilities.invokeLater(this.notifyTableRunnable);
    }

    public void sortByColumns(ColumnToSort[] columnsToSort) {
        this.columnsToSort = Arrays.asList(columnsToSort);
        this.sort();
        this.notifyTableChanged();
    }

    public int[] sortByColumns(ColumnToSort[] columnsToSort, int[] preSortSelectedRows) {
        int[] modelIndexes = new int[preSortSelectedRows.length];
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Selected row indexes before sort" + StylerUtils.style((Object)preSortSelectedRows)));
        }
        for (int i = 0; i < preSortSelectedRows.length; ++i) {
            modelIndexes[i] = this.convertSortedIndexToDataIndex(preSortSelectedRows[i]);
        }
        this.columnsToSort = Arrays.asList(columnsToSort);
        this.sort();
        int[] postSortSelectedRows = new int[modelIndexes.length];
        for (int i = 0; i < modelIndexes.length; ++i) {
            postSortSelectedRows[i] = this.convertModelToRowIndex(modelIndexes[i]);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Selected row indexes after sort" + StylerUtils.style((Object)postSortSelectedRows)));
        }
        this.notifyTableChanged();
        return postSortSelectedRows;
    }

    protected void notifyTableChanged() {
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeLater(this.notifyTableRunnable);
        } else {
            this.notifyTableRunnable.run();
        }
    }

    public int convertSortedIndexToDataIndex(int index) {
        return this.indexes[index];
    }

    public int[] convertSortedIndexesToDataIndexes(int[] indexes) {
        int[] converted = new int[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            converted[i] = this.convertSortedIndexToDataIndex(indexes[i]);
        }
        return converted;
    }

    public int convertModelToRowIndex(int index) {
        for (int i = 0; i < this.indexes.length; ++i) {
            if (index != this.indexes[i]) continue;
            return i;
        }
        return 0;
    }

    public int[] convertDataIndexesToSortedIndexes(int[] indexes) {
        int[] converted = new int[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            converted[i] = this.convertModelToRowIndex(indexes[i]);
        }
        return converted;
    }

    private void sort() {
        if (this.columnsToSort.size() > 0) {
            this.checkModel();
            this.compares = 0;
            this.doShuttleSort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
        }
    }

    private void checkModel() {
        if (this.indexes.length != this.filteredModel.getRowCount()) {
            throw new IllegalStateException("Sorter not informed of a change in model.");
        }
    }

    private void doShuttleSort(int[] from, int[] to, int low, int high) {
        if (high - low < 2) {
            return;
        }
        int middle = (low + high) / 2;
        this.doShuttleSort(to, from, low, middle);
        this.doShuttleSort(to, from, middle, high);
        int p = low;
        int q = middle;
        if (high - low >= 4 && this.compare(from[middle - 1], from[middle]) <= 0) {
            for (int i = low; i < high; ++i) {
                to[i] = from[i];
            }
            return;
        }
        for (int i = low; i < high; ++i) {
            to[i] = q >= high || p < middle && this.compare(from[p], from[q]) <= 0 ? from[p++] : from[q++];
        }
    }

    public int compare(int row1, int row2) {
        ++this.compares;
        for (int level = 0; level < this.columnsToSort.size(); ++level) {
            ColumnToSort column = (ColumnToSort)this.columnsToSort.get(level);
            int result = this.compareRowsByColumn(row1, row2, column.getColumnIndex());
            if (result == 0) continue;
            return column.getSortOrder() == SortOrder.ASCENDING ? result : -result;
        }
        return 0;
    }

    private int compareRowsByColumn(int row1, int row2, int column) {
        Object o1 = this.filteredModel.getValueAt(row1, column);
        Object o2 = this.filteredModel.getValueAt(row2, column);
        Comparator comparator = this.columnComparators[column];
        if (comparator != null) {
            return comparator.compare(o1, o2);
        }
        return COMPARABLE_COMPARATOR.compare(o1, o2);
    }

    public void tableChanged(TableModelEvent e) {
        if (e.getType() == 1) {
            if (this.autoSortEnabled) {
                int i;
                this.reallocateIndexesOnInsert(e.getFirstRow(), e.getLastRow());
                this.sort();
                int[] insertedRows = new int[e.getLastRow() - e.getFirstRow() + 1];
                int row = e.getFirstRow();
                for (i = 0; i < insertedRows.length; ++i) {
                    insertedRows[i] = this.convertModelToRowIndex(row++);
                }
                for (i = 0; i < insertedRows.length; ++i) {
                    this.fireTableRowsInserted(insertedRows[i], insertedRows[i]);
                }
            } else {
                this.reallocateIndexesOnInsert(e.getFirstRow(), e.getLastRow());
                super.tableChanged(e);
            }
        } else if (e.getType() == -1) {
            int i;
            int[] deletedRows = new int[e.getLastRow() - e.getFirstRow() + 1];
            int row = e.getFirstRow();
            for (i = 0; i < deletedRows.length; ++i) {
                deletedRows[i] = this.convertModelToRowIndex(row);
                ++row;
            }
            this.allocateIndexes();
            for (i = 0; i < deletedRows.length; ++i) {
                this.fireTableRowsDeleted(deletedRows[i], deletedRows[i]);
            }
            this.sort();
        } else if (e.getType() == 0) {
            this.allocateIndexes();
            this.sort();
            this.fireTableDataChanged();
        } else {
            this.logger.warn((Object)("Doing an unknown table change type: " + e.getType()));
            this.allocateIndexes();
            this.sort();
            super.tableChanged(e);
        }
    }

    private void reallocateIndexesOnInsert(int firstRow, int lastRow) {
        int row;
        int rowCount = this.filteredModel.getRowCount();
        int[] newIndexes = new int[rowCount];
        for (row = 0; row < this.indexes.length; ++row) {
            newIndexes[row] = this.indexes[row];
        }
        for (row = firstRow; row <= lastRow; ++row) {
            newIndexes[row] = row;
        }
        this.indexes = newIndexes;
    }
}

