/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.text;

import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.form.builder.FormComponentInterceptor;
import org.springframework.richclient.form.builder.FormComponentInterceptorFactory;
import org.springframework.richclient.text.TextComponentInterceptor;

public class TextCaretFormComponentInterceptorFactory
implements FormComponentInterceptorFactory {
    public FormComponentInterceptor getInterceptor(FormModel formModel) {
        return new TextCaretComponentInterceptor();
    }

    private static final class DocumentHandler
    implements DocumentListener {
        private JTextComponent component;

        private DocumentHandler(JTextComponent component) {
            this.component = component;
        }

        public void removeUpdate(DocumentEvent e) {
            this.fixCaret();
        }

        public void insertUpdate(DocumentEvent e) {
            this.fixCaret();
        }

        public void changedUpdate(DocumentEvent e) {
            this.fixCaret();
        }

        private void fixCaret() {
            if (!this.component.hasFocus()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DocumentHandler.this.component.setCaretPosition(0);
                    }
                });
            }
        }
    }

    public class TextCaretComponentInterceptor
    extends TextComponentInterceptor {
        protected void processComponent(String propertyName, JTextComponent textComponent) {
            textComponent.getDocument().addDocumentListener(new DocumentHandler(textComponent));
        }
    }
}

