/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.tree;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import org.springframework.binding.value.ValueModel;

public abstract class AbstractTreeModel
implements TreeModel {
    private final RootHolderChangeHandler rootHolderChangeHandler = new RootHolderChangeHandler();
    private final EventListenerList listenerList = new EventListenerList();
    private Object root;
    private ValueModel rootHolder;

    protected AbstractTreeModel(Object root) {
        this.root = root;
    }

    protected AbstractTreeModel(ValueModel rootHolder) {
        this.rootHolder = rootHolder;
        this.root = rootHolder.getValue();
        this.rootHolder.addValueChangeListener((PropertyChangeListener)this.rootHolderChangeHandler);
    }

    public Object getRoot() {
        return this.root;
    }

    protected ValueModel getRootHolder() {
        return this.rootHolder;
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    public TreeModelListener[] getTreeModelListeners() {
        return (TreeModelListener[])this.listenerList.getListeners(TreeModelListener.class);
    }

    protected void fireTreeNodesChanged(Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? AbstractTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent((Object)this, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
        }
    }

    protected void fireTreeNodesInserted(Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? AbstractTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent((Object)this, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesInserted(e);
        }
    }

    protected void fireTreeNodesRemoved(Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? AbstractTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent((Object)this, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(e);
        }
    }

    protected void fireTreeStructureChanged(Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? AbstractTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent((Object)this, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    protected void fireRootNodeChanged(Object previousRoot) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? AbstractTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent((Object)this, new Object[]{previousRoot});
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
        }
    }

    protected void fireRootTreeStructureChanged(Object previousRoot) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? AbstractTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent((Object)this, new Object[]{previousRoot});
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    protected void fireTreeNodeRemoved(Object[] path, int index, Object child) {
        this.fireTreeNodesRemoved(path, new int[]{index}, new Object[]{child});
    }

    protected void fireTreeNodeInserted(Object[] path, int index, Object child) {
        this.fireTreeNodesInserted(path, new int[]{index}, new Object[]{child});
    }

    protected void fireTreeStructureChanged(Object[] path, int index, Object child) {
        this.fireTreeStructureChanged(path, new int[]{index}, new Object[]{child});
    }

    protected void fireTreeNodeChanged(Object[] path, int index, Object child) {
        this.fireTreeNodesChanged(path, new int[]{index}, new Object[]{child});
    }

    private class RootHolderChangeHandler
    implements PropertyChangeListener {
        private RootHolderChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            AbstractTreeModel.this.fireRootTreeStructureChanged(AbstractTreeModel.this.root);
            AbstractTreeModel.this.root = AbstractTreeModel.this.rootHolder.getValue();
        }
    }
}

