/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.tree;

import java.awt.Component;
import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.FatalBeanException;
import org.springframework.richclient.core.DescribedElement;
import org.springframework.richclient.core.VisualizedElement;
import org.springframework.richclient.tree.FocusableTreeCellRenderer;
import org.springframework.util.Assert;

public class BeanTreeCellRenderer
extends FocusableTreeCellRenderer {
    private BeanInfo beanInfo;
    private String propertyName;

    public BeanTreeCellRenderer() {
    }

    public BeanTreeCellRenderer(Class beanClass) {
        this(beanClass, null);
    }

    public BeanTreeCellRenderer(Class beanClass, String propertyName) {
        Assert.notNull((Object)beanClass);
        try {
            this.beanInfo = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        this.propertyName = propertyName;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node;
        Object bean;
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value instanceof DefaultMutableTreeNode && (bean = (node = (DefaultMutableTreeNode)value).getUserObject()) != null && !BeanUtils.isSimpleProperty(bean.getClass())) {
            Image icon;
            DescribedElement element;
            if (bean instanceof DescribedElement) {
                element = (DescribedElement)bean;
                this.setText(element.getDisplayName());
                this.setToolTipText(element.getCaption());
            } else {
                BeanWrapperImpl wrapper = new BeanWrapperImpl(bean);
                try {
                    Object text = this.propertyName != null ? wrapper.getPropertyValue(this.propertyName) : wrapper.getPropertyValue("name");
                    this.setText(String.valueOf(text));
                }
                catch (FatalBeanException e) {
                    // empty catch block
                }
            }
            if (bean instanceof VisualizedElement) {
                element = (VisualizedElement)bean;
                this.setIcon(element.getIcon());
            } else if (this.beanInfo != null && (icon = this.beanInfo.getIcon(1)) != null) {
                this.setIcon(new ImageIcon(icon));
            }
        }
        return this;
    }
}

