/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.tree;

import java.util.ArrayList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class TreeSelectionListenerSupport
implements TreeSelectionListener {
    private static final TreePath[] EMPTY_TREE_PATH_ARRAY = new TreePath[0];
    private int itemsSelected = 0;

    protected int getItemsSelected() {
        return this.itemsSelected;
    }

    public void valueChanged(TreeSelectionEvent e) {
        TreePath[] paths = e.getPaths();
        ArrayList<TreePath> addedPaths = new ArrayList<TreePath>();
        ArrayList<TreePath> removedPaths = new ArrayList<TreePath>();
        for (int i = 0; i < paths.length; ++i) {
            if (e.isAddedPath(i)) {
                ++this.itemsSelected;
                addedPaths.add(paths[i]);
                continue;
            }
            --this.itemsSelected;
            removedPaths.add(paths[i]);
        }
        if (this.itemsSelected == 1) {
            this.onSingleSelection(e.getNewLeadSelectionPath());
        } else if (this.itemsSelected == 0) {
            this.onNoSelection(removedPaths.toArray(EMPTY_TREE_PATH_ARRAY));
        } else {
            this.onMultiSelection(addedPaths.toArray(EMPTY_TREE_PATH_ARRAY), removedPaths.toArray(EMPTY_TREE_PATH_ARRAY));
        }
    }

    protected void onSingleSelection(TreePath selectedPath) {
    }

    protected void onNoSelection(TreePath[] removedPaths) {
        this.onNoSelection();
    }

    protected void onNoSelection() {
    }

    protected void onMultiSelection(TreePath[] addedPaths, TreePath[] removedPaths) {
        this.onMultiSelection(addedPaths);
    }

    protected void onMultiSelection(TreePath[] addedPaths) {
    }
}

