/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.tree;

import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.springframework.richclient.tree.TreeObject;

public class TreeUtils {
    public static String buildFormattedTreePath(TreeObject treeObject, boolean includeRoot, String delimSymbol) {
        if (treeObject == null) {
            return "";
        }
        TreeObject parent = treeObject;
        if (parent == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        if (delimSymbol == null) {
            delimSymbol = "/";
        }
        boolean firstTime = true;
        while (parent != null) {
            TreeObject p = parent.getParent();
            if (p == null) {
                if (includeRoot) {
                    buffer.insert(0, "/" + parent.getDisplayName() + "/");
                }
            } else if (firstTime) {
                buffer.insert(0, parent.getDisplayName());
                firstTime = false;
            } else {
                buffer.insert(0, parent.getDisplayName() + delimSymbol);
            }
            parent = p;
        }
        return buffer.toString();
    }

    public static void expandAll(JTree tree, boolean expand) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        TreeUtils.expandAll(tree, new TreePath(root), expand);
    }

    public static void expandLevels(JTree tree, int levels, boolean expand) {
        TreeModel model = tree.getModel();
        if (model == null) {
            return;
        }
        TreeNode root = (TreeNode)model.getRoot();
        TreeUtils.expandLevels(tree, new TreePath(root), levels, expand);
    }

    public static void expandLevels(JTree tree, TreePath parent, int levels, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                if (levels <= 0) continue;
                TreeUtils.expandLevels(tree, path, --levels, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public static void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                TreeUtils.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }
}

