/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.LayoutFocusTraversalPolicy;

public class CustomizableFocusTraversalPolicy
extends LayoutFocusTraversalPolicy {
    private static final String FOCUS_ORDER_PROPERTY_NAME = "customFocusOrder";

    public static void installCustomizableFocusTraversalPolicy() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().setDefaultFocusTraversalPolicy(new CustomizableFocusTraversalPolicy());
    }

    public static void customizeFocusTraversalOrder(JComponent container, List componentsInOrder) {
        Iterator i = componentsInOrder.iterator();
        while (i.hasNext()) {
            Component comp = (Component)i.next();
            if (comp.getParent() == container) continue;
            throw new IllegalArgumentException("Component [" + comp + "] is not a child of [" + container + "].");
        }
        container.putClientProperty(FOCUS_ORDER_PROPERTY_NAME, CustomizableFocusTraversalPolicy.createOrderMapFromList(componentsInOrder));
    }

    private static Map createOrderMapFromList(List componentsInOrder) {
        HashMap orderMap = new HashMap(componentsInOrder.size());
        for (int i = 0; i < componentsInOrder.size(); ++i) {
            orderMap.put(componentsInOrder.get(i), new Integer(i));
        }
        return orderMap;
    }

    public CustomizableFocusTraversalPolicy() {
        this.setComparator(new CustomizableFocusTraversalComparator(this.getComparator()));
    }

    private static class CustomizableFocusTraversalComparator
    implements Comparator {
        private Comparator layoutComparator;

        private CustomizableFocusTraversalComparator(Comparator layoutComparator) {
            this.layoutComparator = layoutComparator;
        }

        public int compare(Object o1, Object o2) {
            Component comp1 = (Component)o1;
            Component comp2 = (Component)o2;
            if (comp1 == comp2) {
                return 0;
            }
            Map order = this.getFocusOrder(comp1);
            if (order != null && comp1.getParent() == comp2.getParent()) {
                return this.compareSameParent(order, comp1, comp2);
            }
            if (comp1.getParent() != comp2.getParent()) {
                return this.compareClosestAncestor(comp1, comp2);
            }
            return this.layoutComparator.compare(comp1, comp2);
        }

        private Map getFocusOrder(Component comp) {
            Container parent = comp.getParent();
            return (Map)(parent instanceof JComponent ? ((JComponent)parent).getClientProperty(CustomizableFocusTraversalPolicy.FOCUS_ORDER_PROPERTY_NAME) : null);
        }

        private int compareSameParent(Map order, Component comp1, Component comp2) {
            Integer index1 = (Integer)order.get(comp1);
            Integer index2 = (Integer)order.get(comp2);
            if (index1 != null && index2 != null) {
                return index1 - index2;
            }
            if (index1 != null) {
                return -1;
            }
            if (index2 != null) {
                return 1;
            }
            return this.layoutComparator.compare(comp1, comp2);
        }

        public int compareClosestAncestor(Component comp1, Component comp2) {
            List comp1Ancestors = this.getAncestors(comp1);
            List comp2Ancestors = this.getAncestors(comp2);
            int index1 = comp1Ancestors.size();
            int index2 = comp2Ancestors.size();
            do {
                if (index1 <= 0) {
                    return -1;
                }
                comp1 = (Component)comp1Ancestors.get(--index1);
                if (index2 <= 0) {
                    return 1;
                }
                comp2 = (Component)comp2Ancestors.get(--index2);
            } while (comp1 == comp2);
            return this.compare(comp1, comp2);
        }

        private List getAncestors(Component comp) {
            ArrayList<Component> ancestors = new ArrayList<Component>();
            while (comp != null && !(comp instanceof Window)) {
                ancestors.add(comp);
                comp = comp.getParent();
            }
            return ancestors;
        }
    }
}

